import scala.annotation.tailrec   


def collatz(n: Int): List[Int] =
  if (n == 1) List(1) else
    if (n % 2 == 0) (n::collatz(n / 2)) else 
      (n::collatz(3 * n + 1))

def collatz1(n: Int): Int =
  if (n == 1) 1 else
    if (n % 2 == 0) (1 + collatz1(n / 2)) else 
      (1 + collatz1(3 * n + 1))

@tailrec
def collatz2(n: Long, acc: Int): Int =
  if (n == 1) acc else
    if (n % 2 == 0) collatz2(n / 2, acc + 1) else 
      collatz2(3 * n + 1, acc + 1)

@tailrec
def collatz3(n: BigInt, acc: Int): Int =
  if (n == 1) acc else
    if (n % 2 == 0) collatz3(n / 2, acc + 1) else 
      collatz3(3 * n + 1, acc + 1)

collatz(1)
collatz(2)
collatz(3)
collatz(4)
collatz(5)
collatz(6)
collatz(7)
collatz(8)
collatz(9)
collatz(100000)
println((for (i <- 1 to 100000) yield collatz(i).length).max)
println((for (i <- 1 to 100000) yield collatz1(i)).max)
println((for (i <- 1 to 1000000) yield collatz2(i, 1)).max)
println((for (i <- (1 to 10000000).par) yield collatz2(i, 1)).max)
println((for (i <- (1 to 100000000).par) yield collatz3(i, 1)).max)
