#!/bin/bash

# to make the script fail safely
set -euo pipefail

out=${1:-output}

echo -e "" > $out


echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "for the core part of assignment 9.  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out
echo -e "" >> $out

# marks for CW9
marks=$(( 0 ))

# compilation tests

function scala_compile {
    (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 40; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}

function scala_assert_long {
    (ulimit -t 80; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, return, ListBuffer test
#
echo -e "re.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars re.scala)
then
  echo -e "  --> FAIL (make triple-sure your program conforms to the required format)\n" | tee -a $out
  tsts0=$(( 1 ))
else
  echo -e "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo -e "re.scala runs?" | tee -a $out

  if (scala_compile re.scala)
  then
    echo -e "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN re.scala" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi

### re1 test

if [ $tsts1 -eq 0 ]
then
  echo -e " nullable(ZERO) == false" | tee -a $out
  echo -e " nullable(ONE) == true" | tee -a $out
  echo -e " nullable(CHAR('a')) == false" | tee -a $out
  echo -e " nullable(ZERO | ONE) == true" | tee -a $out
  echo -e " nullable(ZERO | CHAR('a')) == false" | tee -a $out
  echo -e " nullable(ONE ~  ONE) == true" | tee -a $out
  echo -e " nullable(ONE ~ CHAR('a')) == false" | tee -a $out
  echo -e " nullable(STAR(ZERO)) == true" | tee -a $out
  
  if (scala_assert "re.scala" "re_test1.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### re2 test

if [ $tsts1 -eq 0 ]
then
  echo -e " der('a', ZERO | ONE) == (ZERO | ZERO)" | tee -a $out
  echo -e " der('a', (CHAR('a') | ONE) ~ CHAR('a')) == ALT((ONE | ZERO) ~ CHAR('a'), ONE)" | tee -a $out
  echo -e " der('a', (CHAR('a') | CHAR('a')) ~ CHAR('a')) == (ONE | ONE) ~ CHAR('a')" | tee -a $out
  echo -e " der('a', STAR(CHAR('a'))) == (ONE ~ STAR(CHAR('a')))" | tee -a $out
  echo -e " der('b', STAR(CHAR('a'))) == (ZERO ~ STAR(CHAR('a')))" | tee -a $out
  echo -e "" | tee -a $out
  echo -e " val r0 = \"a\" ~ \"b\" ~ \"c\"" | tee -a $out
  echo -e " der('a', r0) == (ONE ~ \"b\") ~ \"c\"" | tee -a $out
  echo -e " der('b', r0) == (ZERO ~ \"b\") ~ \"c\"" | tee -a $out
  echo -e " der('c', r0) == (ZERO ~ \"b\") ~ \"c\"" | tee -a $out
  echo -e "" | tee -a $out
  echo -e " val r1 = (ONE ~ \"b\") ~ \"c\"" | tee -a $out
  echo -e " der('a', r1) == ((ZERO ~ \"b\") | ZERO) ~ \"c\"" | tee -a $out
  echo -e " der('b', r1) == ((ZERO ~ \"b\") | ONE) ~ \"c\"" | tee -a $out
  echo -e " der('c', r1) == ((ZERO ~ \"b\") | ZERO) ~ \"c\"" | tee -a $out
  echo -e "" | tee -a $out
  echo -e " val r2 = ((ZERO ~ \"b\") | ONE) ~ \"c\"" | tee -a $out
  echo -e " der('a', r2) == ((((ZERO ~ \"b\") | ZERO) ~ \"c\") | ZERO)" | tee -a $out
  echo -e " der('b', r2) == ((((ZERO ~ \"b\") | ZERO) ~ \"c\") | ZERO)" | tee -a $out
  echo -e " der('c', r2) == ((((ZERO ~ \"b\") | ZERO) ~ \"c\") | ONE)" | tee -a $out

  if (scala_assert "re.scala" "re_test2.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### re3 test

if [ $tsts1 -eq 0 ]
then
  echo -e " simp(ZERO | ONE) == ONE" | tee -a $out
  echo -e " simp(STAR(ZERO | ONE)) == STAR(ZERO | ONE)" | tee -a $out
  echo -e " simp(ONE ~ (ONE ~ (ONE ~ CHAR('a')))) == CHAR('a')" | tee -a $out
  echo -e " simp(((ONE ~ ONE) ~ ONE) ~ CHAR('a')) == CHAR('a')" | tee -a $out
  echo -e " simp(((ONE | ONE) ~ ONE) ~ CHAR('a')) == CHAR('a')" | tee -a $out
  echo -e " simp(ONE ~ (ONE ~ (ONE ~ ZERO))) == ZERO" | tee -a $out
  echo -e " simp(ALT(ONE ~ (ONE ~ (ONE ~ ZERO)), CHAR('a'))) == CHAR('a')" | tee -a $out
  echo -e " simp(CHAR('a') | CHAR('a')) == CHAR('a')" | tee -a $out
  echo -e " simp(CHAR('a') ~ CHAR('a')) == CHAR('a') ~ CHAR('a')" | tee -a $out
  echo -e " simp(ONE | CHAR('a')) == (ONE | CHAR('a'))" | tee -a $out
  echo -e " simp(ALT((CHAR('a') | ZERO) ~ ONE," | tee -a $out
  echo -e "          ((ONE | CHAR('b')) | CHAR('c')) ~ (CHAR('d') ~ ZERO))) == CHAR('a')" | tee -a $out
  echo -e " simp((ZERO | ((ZERO | ZERO) | (ZERO | ZERO))) ~ ((ONE | ZERO) | ONE ) ~ (CHAR('a'))) == ZERO" | tee -a $out
  echo -e " simp(ALT(ONE | ONE, ONE | ONE)) == ONE" | tee -a $out
  echo -e " simp(ALT(ZERO | CHAR('a'), CHAR('a') | ZERO)) == CHAR('a')" | tee -a $out
  echo -e " simp(ALT(ONE | CHAR('a'), CHAR('a') | ONE)) == ALT(ONE | CHAR('a'), CHAR('a') | ONE)" | tee -a $out
  
  if (scala_assert "re.scala" "re_test3.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### re4 test

if [ $tsts1 -eq 0 ]
then
  echo -e " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" | tee -a $out
  echo -e " ders((\"a\" * 5).toList,EVIL) == SEQ(SEQ(STAR(CHAR('a')),STAR(STAR(CHAR('a')))),CHAR('b'))" | tee -a $out
  echo -e " ders(List('b'),EVIL) == ONE" | tee -a $out
  echo -e " ders(List('b','b'),EVIL) == ZERO" | tee -a $out
  echo -e " matcher(EVIL, \"a\" * 5 ++ \"b\") == true" | tee -a $out
  echo -e " matcher(EVIL, \"a\" * 50 ++ \"b\") == true" | tee -a $out
  echo -e " matcher(EVIL, \"a\" * 50) == false" | tee -a $out
  echo -e " matcher(EVIL, \"b\") == true" | tee -a $out
  echo -e " matcher(EVIL, \"bb\") == false" | tee -a $out
  echo -e " matcher(\"abc\", \"abc\") == true" | tee -a $out
  echo -e " matcher(\"abc\", \"ab\") == true" | tee -a $out
  echo -e " matcher((\"ab\" | \"a\") ~ (ONE | \"bc\"), \"abc\") == true" | tee -a $out
  echo -e " matcher(ONE, \"\") == true" | tee -a $out
  echo -e " matcher(ZERO, \"\") == false" | tee -a $out
  echo -e " matcher(ONE | CHAR('a'), \"\") == true" | tee -a $out
  echo -e " matcher(ONE | CHAR('a'), \"a\") == true" | tee -a $out
  
  if (scala_assert "re.scala" "re_test4.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### re5 test


if [ $tsts1 -eq 0 ]
then
  echo -e " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" | tee -a $out  
  echo -e " size(der('a', der('a', EVIL))) == 28" | tee -a $out
  echo -e " size(der('a', der('a', der('a', EVIL)))) == 58" | tee -a $out
  echo -e " size(ders(\"aaaaaa\".toList, EVIL)) == 8" | tee -a $out
  echo -e " size(ders((\"a\" * 50).toList, EVIL)) == 8" | tee -a $out
  
  if (scala_assert "re.scala" "re_test5.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### re6 'power' test



if [ $tsts1 -eq 0 ]
then
  echo -e " simp(Iterator.iterate(ONE:Rexp)(r => SEQ(r, ONE | ONE)).drop(50).next) == ONE" | tee -a $out
  echo -e "    ...the Iterator produces the rexp" | tee -a $out
  echo -e "" | tee -a $out
  echo -e "      SEQ(SEQ(SEQ(..., ONE | ONE) , ONE | ONE), ONE | ONE)" | tee -a $out
  echo -e "" | tee -a $out
  echo -e "    where SEQ is nested 50 times." | tee -a $out  
  echo -e "" | tee -a $out
  echo -e " simp(Iterator.iterate(ONE:Rexp)(r => ALT(r, r)).drop(20).next) == ONE" | tee -a $out
  echo -e "    ... the Iterator produces a rexp of size 2097151" | tee -a $out
  echo -e "" | tee -a $out
  echo -e " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" | tee -a $out
  echo -e " matcher(EVIL, \"a\" * 1000000 ++ \"b\") == true" | tee -a $out
  echo -e " matcher(EVIL, \"a\" * 1000000) == false" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_long "re.scala" "re_test6.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo "  It took $DIFF seconds" | tee -a $out
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo "  It took $DIFF seconds" | tee -a $out
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi


## final marks
echo -e "Overall mark for CW 9, Core Part" | tee -a $out
echo -e "$marks" | tee -a $out


