// Main Part 3 about Evil Wordle
//===============================

// test bash

object M2 { 

import io.Source
import scala.util._

// ADD YOUR CODE BELOW
//======================

// test import


//(1)
def get_wordle_list(url: String) : List[String] = {
  Try(Source.fromURL(url)("ISO-8859-1").getLines().toList).getOrElse(Nil)
}


// val secrets = get_wordle_list("https://nms.kcl.ac.uk/christian.urban/wordle.txt")
// secrets.length // => 12972
// secrets.filter(_.length != 5) // => Nil

//(2)
def removeN[A](xs: List[A], elem: A, n: Int) : List[A] = {
    if (n == 0) xs 
    else xs match {
        case Nil => Nil
        case x::xs => 
            if (x == elem) removeN(xs, x, n - 1) 
            else x::removeN(xs, elem, n)
    } 
}    


// removeN(List(1,2,3,2,1), 3, 1)  // => List(1, 2, 2, 1)
// removeN(List(1,2,3,2,1), 2, 1)  // => List(1, 3, 2, 1)
// removeN(List(1,2,3,2,1), 1, 1)  // => List(2, 3, 2, 1)
// removeN(List(1,2,3,2,1), 0, 2)  // => List(1, 2, 3, 2, 1)

// (3)
abstract class Tip
case object Absent extends Tip
case object Present extends Tip
case object Correct extends Tip


def pool(secret: String, word: String) : List[Char] = {
  for (i <- (0 to 4).toList 
       if secret(i) != word(i))
  yield secret(i) 
}

def aux(secret: List[Char], word: List[Char], pool: List[Char]) : List[Tip] = (secret, word) match {
    case (Nil, Nil) => Nil
    case (s::srest, w::wrest) => {
        if (s == w) Correct::aux(srest, wrest, pool)
        else if (pool.contains(w)) Present::aux(srest, wrest, removeN(pool, w, 1))
        else  Absent::aux(srest, wrest, pool)
    }
}


def score(secret: String, word: String) : List[Tip] = 
  aux(secret.toList, word.toList, pool(secret, word))


// score("chess", "caves") // => List(Correct, Absent, Absent, Present, Correct)
// score("doses", "slide") // => List(Present, Absent, Absent, Present, Present)
// score("chess", "swiss") // => List(Absent, Absent, Absent, Correct, Correct)
// score("chess", "eexss") // => List(Present, Absent, Absent, Correct, Correct)

// (4)
def eval(t: Tip) : Int = t match {
    case Correct => 10
    case Present => 1
    case Absent => 0
}

def iscore(secret: String, word: String) : Int = 
  score(secret, word).map(eval).sum

//iscore("chess", "caves") // => 21
//iscore("chess", "swiss") // => 20

// (5)
def lowest(secrets: List[String], word: String, current: Int, acc: List[String]) : List[String] = secrets match {
    case Nil => acc
    case s::srest => {
        val nscore = iscore(s, word)
        if (nscore < current) lowest(srest, word, nscore, List(s)) 
        else if (nscore == current) lowest(srest, word, current, s::acc)
        else  lowest(srest, word, current, acc)
    }
}

def evil(secrets: List[String], word: String) = 
  lowest(secrets, word, Int.MaxValue, Nil)


//evil(secrets, "stent").length
//evil(secrets, "hexes").length
//evil(secrets, "horse").length
//evil(secrets, "hoise").length
//evil(secrets, "house").length

// (6)
def frequencies(secrets: List[String]) : Map[Char, Double] = {
    val all = secrets.flatten
    all.groupBy(identity).view.mapValues(1.0D - _.size.toDouble / all.size ).toMap
}

// (7)
def rank(frqs: Map[Char, Double], s: String) = {
    s.map(frqs(_)).sum
}


def ranked_evil(secrets: List[String], word: String) = {
    val frqs = frequencies(secrets)
    val ev = evil(secrets, word)
    ev.groupBy(rank(frqs, _)).toList.sortBy(_._1).reverse.head._2
}


}






// This template code is subject to copyright 
// by King's College London, 2022. Do not 
// make the template code public in any shape 
// or form, and do not exchange it with other 
// students under any circumstance.
