// Part 1 about Roman Numerals
//=============================


abstract class RomanDigit 
case object I extends RomanDigit 
case object V extends RomanDigit 
case object X extends RomanDigit 
case object L extends RomanDigit 
case object C extends RomanDigit 
case object D extends RomanDigit 
case object M extends RomanDigit 

type RomanNumeral = List[RomanDigit] 

// (1) First write a polymorphic function that recursively
// transforms a list of options into an option of a list.
// As soon as a None is inside the list, the result is None. 
// Otherwise produce a list of all Some's appended.

def optionlist[A](xs: List[Option[A]]): Option[List[A]] = 

// (2) Write a function first a function that converts a character
// into a roman digit (if possible). Then convert a string into
// a roman numeral (if possible). If this is not possible, the functions
// should return None.

def Char2RomanDigit(c: Char): Option[RomanDigit] = 

def String2RomanNumeral(s: String) : Option[RomanNumeral] = 


// some test cases
//String2RomanNumeral("IIII")
//String2RomanNumeral("IV")
//String2RomanNumeral("VI")
//String2RomanNumeral("IX")
//String2RomanNumeral("MCMLXXIX")
//String2RomanNumeral("MCMXLIV") 
//String2RomanNumeral("M C M X L I V")  // None

// (3) Write a recursive function RomanNumral2Int that converts a
// RomanNumeral into an integer.

def RomanNumeral2Int(rs: RomanNumeral): Int = 


// some test cases
RomanNumeral2Int(List(I,I,I,I))         // 4
RomanNumeral2Int(List(I,V))             // 4
RomanNumeral2Int(List(V,I))             // 6
RomanNumeral2Int(List(I,X))             // 9
RomanNumeral2Int(List(M,C,M,L,X,X,I,X)) // 1979
RomanNumeral2Int(List(M,C,M,X,L,I,V))   // 1944

// (4) Write a function that converts a string (containing
// a roman numeral) into an integer (if possible). If not
// this is not possible, the functions should return None.

def String2Int(s: String): Option[Int] = 

// some test cases
String2Int("IIII")      // 4 (though invalid roman numeral)  
String2Int("IV")        // 4
String2Int("VI")        // 6
String2Int("IX")        // 9
String2Int("MCMLXXIX")  // 1979
String2Int("MCMXLIV")   // 1944
String2Int("")          // 0
String2Int("MDCLXI")    // 1661
String2Int("MMMCMXCIX") // 3999
String2Int("XLVIII")    // 48
String2Int("MMVIII")    // 2008

String2Int("MMXI")      // 2011 
String2Int("MIM")       // 1999
String2Int("MCMLVI")    // 1956 

String2Int("III") 	// 3
String2Int("XXX") 	// 30
String2Int("CCC") 	// 300
String2Int("MMM") 	// 3000
String2Int("VII") 	// 7
String2Int("LXVI") 	// 66
String2Int("CL") 	// 150
String2Int("MCC") 	// 1200
String2Int("IV") 	// 4
String2Int("IX") 	// 9
String2Int("XC") 	// 90
String2Int("MDCLXVI")	// 1666

String2Int("VIV")       // 9 (but should be written as IX) 
String2Int("IVX")       // 14 (also invalid)

// error cases
String2Int("MC?I")
String2Int("abc")


// (5) The file roman.txt contains a list of roman numerals. 
// Read in these numerals from the file, convert them into 
// integers and then add them all up.

import io.Source
import scala.util._

// function for reading files:
// Source.fromFile("file_name")("ISO-8859-9")

def addromanfile(filename: String) =

//test case
addromanfile("roman.txt")


// Part 2 about Validation of Roman Numerals
//===========================================

// (6) Write a function that validates roman numerals according
// to the rules given in the CW.

def isValidNumeral(digitList: RomanNumeral): Boolean =



// some test cases
val invalids = List("IXC", "XCX", "IIII", "IIIII", "DD", "VL", 
                    "MIM", "XXCIII", "LXXIIX", "IIIIX", "IIXX", 
                    "ICM", "CIM", "VIV", "IVX", "MCMC", "XIIX", "IIXX")

val valids = List("IV", "VI", "IX", "MCMLXXIX", "MCMXLIV", "", "MDCLXI",
                  "MMMCMXCIX", "XLVIII", "MMVIII", "MMXI", "MCMLVI", "III",
                  "XXX", "CCC", "MMM", "VII", "LXVI", "CL", "MCC", "XC",
                  "MDCLXVI")

// (7) Write a recursive function that converts an Integer into a
// a roman numeral. The input will be between 0 and 3999.

def Int2Roman(n: Int): RomanNumeral =

// (8) Write a function that reads a text file containing valid and 
// invalid roman numerals. Convert all valid roman numerals into integers, 
// add them up and produce the result as a roman numeral (using the 
// function in (7)

def addvalidromanfile(filename: String) =

// a test case
//addvalidromanfile("roman2.txt")
