#!/bin/bash
set -euo pipefail


out=${1:-output}

echo -e "" > $out


echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "of Preliminar 9.  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out
echo -e "" >> $out

# marks for CW9 preliminary
marks=$(( 0 ))


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out)   
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null) 
}

# purity test

function scala_vars {
#   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
    (egrep '\bvar\b|\breturn\b|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}



# var, return, ListBuffer test
#
echo -e "postfix.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars postfix.scala)
then
  echo -e "  --> FAIL\n" | tee -a $out  
  tsts0=$(( 1 ))
else
  echo -e "  --> success" | tee -a $out  
  tsts0=$(( 0 )) 
fi

# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo -e "postfix.scala runs?" | tee -a $out

  if (scala_compile postfix.scala)
  then
    echo -e "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN postfix.scala" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


### postfix tests

if [ $tsts1 -eq 0 ]
then
  echo -e " syard(split(\"3 + 4 * ( 2 - 1 )\")) == List(\"3\", \"4\", \"2\", \"1\", \"-\", \"*\", \"+\")" | tee -a $out
  echo -e " syard(split(\"( ( ( 3 ) ) + ( ( 4 + ( 5 ) ) ) )\")) == List(\"3\", \"4\", \"5\", \"+\", \"+\")" | tee -a $out
  echo -e " syard(split(\"5 + 7 / 2\")) == List(\"5\", \"7\", \"2\", \"/\", \"+\")" | tee -a $out
  echo -e " syard(split(\"5 * 7 / 2\")) == List(\"5\", \"7\", \"*\", \"2\", \"/\")" | tee -a $out
  
  if (scala_assert "postfix.scala" "postfix_test7.scala")
  then
    echo -e "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo -e " compute(syard(split(\"3 + 4 * ( 2 - 1 )\"))) == 7" | tee -a $out
  echo -e " compute(syard(split(\"10 + 12 * 33\"))) == 406" | tee -a $out
  echo -e " compute(syard(split(\"( 5 + 7 ) * 2\"))) == 24" | tee -a $out
  echo -e " compute(syard(split(\"5 + 7 / 2\"))) == 8" | tee -a $out
  echo -e " compute(syard(split(\"5 * 7 / 2\"))) == 17" | tee -a $out
  echo -e " compute(syard(split(\"9 + 24 / ( 7 - 3 )\"))) == 15" | tee -a $out
  
  if (scala_assert "postfix.scala" "postfix_test8.scala")
  then
     echo -e "  --> success" | tee -a $out
     marks=$(( marks + 1 ))
  else
     echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi



### postfix2 tests

# var, return, ListBuffer test
#
echo -e "postfix2.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars postfix2.scala)
then
  echo -e "  --> FAIL\n" | tee -a $out  
  tsts0=$(( 1 ))
else
  echo -e "  --> success" | tee -a $out  
  tsts0=$(( 0 )) 
fi


# compilation test

if  [ $tsts0 -eq 0 ]
then    
  echo -e "postfix2.scala runs?" | tee -a $out

  if (scala_compile postfix2.scala)
  then
    echo -e "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN postfix2.scala" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


if [ $tsts1 -eq 0 ]
then
  echo -e " syard(split(\"3 + 4 * ( 2 - 1 )\")) == List(\"3\", \"4\", \"2\", \"1\", \"-\", \"*\", \"+\")" | tee -a $out
  echo -e " syard(split(\"( ( ( 3 ) ) + ( ( 4 + ( 5 ) ) ) )\")) == List(\"3\", \"4\", \"5\", \"+\", \"+\")" | tee -a $out
  echo -e " syard(split(\"5 + 7 / 2\")) == List(\"5\", \"7\", \"2\", \"/\", \"+\")" | tee -a $out
  echo -e " syard(split(\"5 * 7 / 2\")) == List(\"5\", \"7\", \"*\", \"2\", \"/\")" | tee -a $out
  echo -e " syard(split(\"3 + 4 * 8 / ( 5 - 1 ) ^ 2 ^ 3\")) == " | tee -a $out
  echo -e "         List(\"3\", \"4\", \"8\", \"*\", \"5\", \"1\", \"-\", \"2\", \"3\", \"^\", \"^\", \"/\", \"+\")" | tee -a $out
  
  if (scala_assert "postfix2.scala" "postfix_test9.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

if [ $tsts1 -eq 0 ]
then
  echo -e " compute(syard(split(\"3 + 4 * ( 2 - 1 )\"))) == 7" | tee -a $out
  echo -e " compute(syard(split(\"10 + 12 * 33\"))) == 406" | tee -a $out
  echo -e " compute(syard(split(\"( 5 + 7 ) * 2\"))) == 24" | tee -a $out
  echo -e " compute(syard(split(\"5 + 7 / 2\"))) == 8" | tee -a $out
  echo -e " compute(syard(split(\"5 * 7 / 2\"))) == 17" | tee -a $out
  echo -e " compute(syard(split(\"9 + 24 / ( 7 - 3 )\"))) == 15" | tee -a $out
  echo -e " compute(syard(split(\"4 ^ 3 ^ 2\"))) == 262144" | tee -a $out
  echo -e " compute(syard(split(\"4 ^ ( 3 ^ 2 )\"))) == 262144" | tee -a $out
  echo -e " compute(syard(split(\"( 4 ^ 3 ) ^ 2\"))) == 4096" | tee -a $out
  echo -e " compute(syard(split(\"( 3 + 1 ) ^ 2 ^ 3\"))) == 65536" | tee -a $out
  
  if (scala_assert "postfix2.scala" "postfix_test10.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

## final marks
echo -e "Overall mark for CW 9, Preliminary Part" | tee -a $out
echo -e "$marks" | tee -a $out
