/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.None$;
import scala.PartialFunction;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.parallel.Task;
import scala.collection.parallel.Tasks;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class FutureTasks
implements Tasks {
    private ArrayBuffer debugMessages;
    private final int maxdepth;
    private final ExecutionContext environment;

    public FutureTasks(ExecutionContext executor) {
        Tasks.$init$(this);
        this.maxdepth = (int)(package$.MODULE$.log(Int$.MODULE$.int2double(this.parallelismLevel())) / package$.MODULE$.log(2.0) + 1.0);
        this.environment = executor;
        Statics.releaseFence();
    }

    public ArrayBuffer debugMessages() {
        return this.debugMessages;
    }

    @Override
    public void scala$collection$parallel$Tasks$_setter_$debugMessages_$eq(ArrayBuffer x$0) {
        this.debugMessages = x$0;
    }

    public ExecutionContext environment() {
        return this.environment;
    }

    private <R, Tp> Future<R> exec(Task<R, Tp> topLevelTask) {
        ExecutionContext ec = this.environment();
        return this.compute$1(ec, topLevelTask, 0).map((Function1 & Serializable)t -> {
            t.forwardThrowable();
            return t.result();
        }, ec);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R, Tp> Function0<R> execute(Task<R, Tp> task) {
        void var3_3;
        Future future = this.exec(task);
        Function0 & Serializable callback = (Function0 & Serializable)() -> Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        return var3_3;
    }

    @Override
    public <R, Tp> R executeAndWaitResult(Task<R, Tp> task) {
        return (R)this.execute(task).apply();
    }

    @Override
    public int parallelismLevel() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final Task compute$5$$anonfun$4(Task task$2) {
        task$2.tryLeaf(None$.MODULE$);
        return task$2;
    }

    private final Future compute$1(ExecutionContext ec$3, Task task, int depth) {
        Future future;
        if (task.shouldSplitFurther() && depth < this.maxdepth) {
            Seq subtasks = task.split();
            Iterator subfutures = subtasks.iterator().map((Function1 & Serializable)subtask -> this.compute$1(ec$3, (Task)subtask, depth + 1));
            future = ((Future)subfutures.reduceLeft((Function2 & Serializable)(firstFuture, nextFuture) -> firstFuture.flatMap((Function1 & Serializable)firstTask -> nextFuture.map((Function1 & Serializable)nextTask -> {
                firstTask.tryMerge(nextTask.repr());
                return firstTask;
            }, ec$3), ec$3))).andThen((PartialFunction)new Serializable(task){
                private final Task task$1;
                {
                    this.task$1 = task$3;
                }

                public final boolean isDefinedAt(Try x) {
                    boolean bl;
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        Task firstTask = (Task)((Success)try_).value();
                        bl = true;
                    } else if (try_ instanceof Failure) {
                        Throwable exception = ((Failure)try_).exception();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Object object;
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        Task firstTask = (Task)((Success)try_).value();
                        this.task$1.throwable_$eq(firstTask.throwable());
                        this.task$1.result_$eq(firstTask.result());
                        object = BoxedUnit.UNIT;
                    } else if (try_ instanceof Failure) {
                        Throwable exception = ((Failure)try_).exception();
                        this.task$1.throwable_$eq(exception);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            }, ec$3);
        } else {
            future = Future$.MODULE$.apply(() -> FutureTasks.compute$5$$anonfun$4(task), ec$3);
        }
        return future;
    }
}

