
def urbanmain() = {

  import M5b._

  import io.Source
  import scala.util._

  def urban_load_bff(name: String) : String = 
    Try(Source.fromFile(name)("ISO-8859-1").mkString).getOrElse("")


  import scala.concurrent._
  import scala.concurrent.duration._
  import ExecutionContext.Implicits.global
  import scala.language.postfixOps 

  lazy val f = Future {
    assert(combine(optimise(urban_load_bff("benchmark.bf"))).length == 134)
    assert(combine(optimise(urban_load_bff("sierpinski.bf"))).length == 122)

    assert(run4("[-]", Map(0 -> 100)) == Map(0 -> 0))
    assert(run4("[->+<]", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10))
    assert(run4("[>>+>>+<<<<-]", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42))
    val hw_urban2 = """+++++[->++++++++++<]>--<+++[->>++++++++++
                  <<]>>++<<----------[+>.>.<+<]"""
    assert(run4(hw_urban2) == Map(0 -> 0, 1 -> 58, 2 -> 32))

    val hw_urban3 = """++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---.
                   +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++."""

    assert(run4(hw_urban3) == Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87))
  }

  Await.result(f, 32 second)
}
