#!/bin/zsh

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo -e `date` >> $out
echo -e  "" >> $out
echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "for Part 5 (Scala).  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out

#echo -e "" >> $out
#echo -e "XXX needs to have own version of load_bff in the testing code" >> $out
#echo -e "" >> $out

# marks for CW10 part 1
marks=$(( 0.0 ))

# compilation tests

function scala_compile {
    (timeout 35s scala-cli compile --server=false -color never -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (timeout 35s scala-cli --server=false -i "$1" "$2" -e "urbanmain()" 2> /dev/null 1> /dev/null)
}

function scala_assert_thirty {
  (timeout 35s scala-cli --server=false -i "$1" "$2" -e "urbanmain()" 2> /dev/null 1> /dev/null)
}


# purity test
function scala_vars {
   (sed 's/immutable/ok/g' c$out > cb$out;
    egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' cb$out 2> /dev/null 1> /dev/null)
}



echo -e "" >> $out
echo -e "Below is the feedback for your submission of bf.scala" >> $out
echo -e "" >> $out

# compilation test
echo -e "bf.scala runs?" | tee -a $out

if (scala_compile bf.scala)
then
    echo -e "  --> success" | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN bf.scala\n" | tee -a $out
    tsts=$(( 1 )) 
fi


# var, return, ListBuffer test
#
if  [ $tsts -eq 0 ]
then   
    echo -e "bf.scala does not contain VARS, RETURNS etc?" | tee -a $out

    if (scala_vars bf.scala)   
    then
	echo -e "  --> TEST FAILED\n" | tee -a $out
	tsts=$(( 1 ))
    else
	echo -e "  --> success\n" | tee -a $out
	tsts=$(( 0 )) 
    fi
else
    tsts=$(( 1 ))  
fi    



### bf1 test

if [ $tsts -eq 0 ]
then
  echo -e " load_bff(\"benchmark.bf\").length == 188" | tee -a $out
  echo -e " load_bff(\"foobar.bf\") == \"\"" | tee -a $out  
   
  if (scala_assert "bf.scala" "bf_test1.scala")
  then
      echo -e "  --> success (+ 0.5 Marks)\n" | tee -a $out
      marks=$(( marks + 0.5 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi


### bf2 test

if [ $tsts -eq 0 ]
then
  echo -e " sread(Map(), 2) == 0" | tee -a $out
  echo -e " sread(Map(2 -> 1), 2) == 1" | tee -a $out  
  echo -e " write(Map(), 1, 2) == Map(1 -> 2)" | tee -a $out
  echo -e " write(Map(1 -> 0), 1, 2) == Map(1 -> 2)" | tee -a $out
  
  if (scala_assert "bf.scala" "bf_test2.scala")
  then
      echo -e "  --> success (+ 0.5 Marks)\n" | tee -a $out
      marks=$(( marks + 0.5 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### bf3 test

if [ $tsts -eq 0 ]
then
    echo -e " jumpRight(\"[xxxxxx]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpRight(\"[xx[x]x]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpRight(\"[xx[x]x]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpRight(\"[xx[xxx]xxx\", 1, 0) == 11" | tee -a $out
    echo -e " jumpRight(\"[x[][]x]xxx\", 1, 0) == 8" | tee -a $out
    echo -e " jumpLeft(\"[xxxxxx]xxx\", 6, 0) == 1" | tee -a $out
    echo -e " jumpLeft(\"[xxxxxx]xxx\", 7, 0) == -1" | tee -a $out
    echo -e " jumpLeft(\"[x[][]x]xxx\", 6, 0) == 1" | tee -a $out
    START=$(date +%s)
    
  if (scala_assert "bf.scala" "bf_test3.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  --> success (+ 2 Marks)\n" | tee -a $out
      marks=$(( marks + 2.0 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out 
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi



if [ $tsts -eq 0 ]
then
  echo -e " run(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  
  echo -e " run(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert "bf.scala" "bf_test4.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out 
      echo -e "  --> success (+ 1 Mark)\n" | tee -a $out
      marks=$(( marks + 1.0 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out 
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi


if [ $tsts -eq 0 ]
then
  echo -e " Is run fast enough?" | tee -a $out 
  echo -e " val bench_small = \"\"\">+[<+++++++++++++>-]<[[>+>+<<-]>[<+>-]++++++++" | tee -a $out
  echo -e "  [>++++++++<-]>.[-]<<>++++++++++[>++++++++++[>++" | tee -a $out
  echo -e "  ++++++++[>++++++++++[>++++++++++[>++++++++++[>+" | tee -a $out
  echo -e "  +++++++++[-]<-]<-]<-]<-]<-]<-]<-]++++++++++.\"\"\"" | tee -a $out
  echo -e " run(bench_small, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 10, 5 -> 0, 1 -> 0, 6 -> 0, 2 -> 0, 7 -> 0, 3 -> 0, 4 -> 0)" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "bf.scala" "bf_test4b.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> success (+ 1 Mark)\n" | tee -a $out
      marks=$(( marks + 1.0 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi

if [ $tsts -eq 0 ]
then
  echo -e " val str = \"\"\"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++.[-]++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++.[-]+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++.[-]\"\"\"" | tee -a $out
  echo -e " " | tee -a $out
  echo -e " run(generate(\"ABC\".toList)) == str" | tee -a $out
  
  if (scala_assert_thirty "bf.scala" "bf_test4c.scala")
  then
      echo -e "  --> success (+ 1 Mark)\n" | tee -a $out
      marks=$(( marks + 1.0 ))
  else
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi


echo -e "" >> $out
echo -e "Below is the feedback for your submission of bfc.scala" >> $out
echo -e "" >> $out


# compilation test
echo "bfc.scala runs?" | tee -a $out

if (scala_compile bfc.scala)
then
    echo -e "  --> success" | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN bfc.scala\n" | tee -a $out
    tsts=$(( 1 )) 
fi

# var, return, ListBuffer test
#

if [ $tsts -eq 0 ]
then 
    echo "bfc.scala does not contain VARS, RETURNS etc?" | tee -a $out

    if (scala_vars bfc.scala)
    then
	echo -e "  --> TEST FAILED\n" | tee -a $out
	tsts=$(( 1 ))
    else
	echo -e "  --> success" | tee -a $out
	tsts=$(( 0 )) 
    fi
else
  tsts=$(( 1 ))     
fi


### bfc5 test

if [ $tsts -eq 0 ]
then
  echo -e " val p1 = \"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++<<]>>++<<----------[+>.>.<+<]\"\"\"" | tee -a $out
  echo -e " jtable(p1) == Map(69 -> 61, 5 -> 20, 60 -> 70, 27 -> 44, 43 -> 28, 19 -> 6)" | tee -a $out  
  echo -e " val p2 = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---.+++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " jtable(p2) == Map(14 -> 34, 33 -> 15, 45 -> 44, 48 -> 9, 43 -> 46, 8 -> 49)" | tee -a $out
  echo -e " run2(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run2(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run2(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo -e " run2(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run2(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert "bfc.scala" "bf_test5.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> success (+ 1 Mark)\n" | tee -a $out
      marks=$(( marks + 1.0 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi


### bfc6 test

if [ $tsts -eq 0 ]
then
  echo -e " optimise(load_bff(\"benchmark.bf\")).length == 181" | tee -a $out
  echo -e " optimise(load_bff(\"sierpinski.bf\")).length == 110" | tee -a $out  
  echo -e " run3(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run3(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run3(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo -e " run3(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run3(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert "bfc.scala" "bf_test6.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> success (+ 1 Mark)\n" | tee -a $out
      marks=$(( marks + 1.0 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### bfc7 test

if [ $tsts -eq 0 ]
then
  echo -e " combine(optimise(load_bff(\"benchmark.bf\"))).length == 134" | tee -a $out
  echo -e " combine(optimise(load_bff(\"sierpinski.bf\"))).length == 122" | tee -a $out
  echo -e " run4(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run4(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run4(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo -e " run4(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run4(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert "bfc.scala" "bf_test7.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  END=$(date +%s)
      echo -e "  --> success (+ 2 Marks)" | tee -a $out
      marks=$(( marks + 2.0 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out     
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi


## final marks
echo -e "Overall mark for Part 5 (Scala)" | tee -a $out
printf " %0.1f\n" $marks | tee -a $out

