#!/bin/zsh

# to make the script fail safely
set -euo pipefail

out=${1:-output}

echo "" > $out

echo `date` >> $out
echo -e "" >> $out
echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "of the Preliminary Part of Part 4 (Scala).  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out
echo -e "" >> $out

echo -e "" >> $out
echo -e "Below is the feedback for your submission knight1.scala" >> $out
echo -e "" >> $out



# marks for CW8 part 1
marks=$(( 0.0 ))

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

function scala_assert_slow {
  (ulimit -t 120; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)  
}

function scala_assert_thirty {
  (ulimit -t 40; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)  
}

function scala_assert_quick {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)    
}

function scala_assert_long {
  (ulimit -t 60; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)    
}

function scala_assert_elong {
  (ulimit -t 90; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null) 
}

# purity test


function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}


# compilation test

echo -e "knight1.scala runs?" | tee -a $out

if (scala_compile knight1.scala)
then
    echo -e "  --> success " | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN KNIGHT1.SCALA\n" | tee -a $out
    tsts=$(( 1 )) 
fi


# knights1: purity test
if  [ $tsts -eq 0 ]
  then   
  echo -e "knight1.scala does not contain VARS, RETURNS etc?" | tee -a $out

  if (scala_vars knight1.scala)
  then
     echo -e "  --> FAIL\n" | tee -a $out
     tsts=$(( 1 ))
  else
     echo -e "  --> success" | tee -a $out
     tsts=$(( 0 )) 
  fi
else
  tsts=$(( 1 ))  
fi

echo >> $out

### knight1 test

if [ $tsts -eq 0 ]
then
    echo " is_legal(8, Nil, (3, 4)) == true " | tee -a $out
    echo " is_legal(8, List((4, 1), (1, 0)), (4, 1)) == false " | tee -a $out
    echo " is_legal(2, Nil, (0, 0)) == true" | tee -a $out                          

    if (scala_assert "knight1.scala" "knight1_test1.scala")
    then
        echo -e "  --> success" | tee -a $out
	marks=$(( marks + 1.0 ))
    else
        echo -e "  --> \n ONE TEST FAILED\n"| tee -a $out
    fi
fi

### knight2 test

if [ $tsts -eq 0 ]
then
  echo " legal_moves(8, Nil, (2,2)) == List((3,4), (4,3), (4,1), (3,0), (1,0), (0,1), (0,3), (1,4))" | tee -a $out
  echo " legal_moves(8, Nil, (7,7)) == List((6,5), (5,6))" | tee -a $out
  echo " legal_moves(8, List((4,1), (1,0)), (2,2)) == List((3,4), (4,3), (3,0), (0,1), (0,3), (1,4))" | tee -a $out
  echo " legal_moves(8, Nil, (0,1)) == List((1,3), (2,2), (2,0))" | tee -a $out
  echo " legal_moves(8, List((6,6)), (7,7)) == List((6,5), (5,6))" | tee -a $out
  echo " legal_moves(1, Nil, (0,0)) == Nil" | tee -a $out
  echo " legal_moves(2, Nil, (0,0)) == Nil" | tee -a $out
  echo " legal_moves(3, Nil, (0,0)) == List((1,2), (2,1))" | tee -a $out
  
  if (scala_assert "knight1.scala" "knight1_test2.scala")
  then
     echo -e "  --> success\n" | tee -a $out
     marks=$(( marks + 1 ))
  else
     echo -e "  --> ONE TEST FAILED\n" | tee -a $out
  fi
fi


### knight3 test

if [ $tsts -eq 0 ]
then
  echo " count_tours from every position on the board 1 - 4 (0.5% marks)" | tee -a $out
  echo " dim = 1: 1" | tee -a $out
  echo "       2: 0,0,0,0" | tee -a $out
  echo "       3: 0,0,0,0,0,0,0,0,0" | tee -a $out
  echo "       4: 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "knight1.scala" "knight1_test3a.scala") 
  then
     END=$(date +%s)
     DIFF=$(( $END - $START ))
     #echo " This test ran for $DIFF seconds." | tee -a $out  
     echo -e "  --> success\n" | tee -a $out
     marks=$(( marks + 0.5 ))
  else
     END=$(date +%s)
     DIFF=$(( $END - $START ))
     echo " This test ran for $DIFF seconds." | tee -a $out 
     echo -e "  --> ONE TEST FAILED\n" | tee -a $out
  fi
fi



if [ $tsts -eq 0 ]
then
  echo " count_tours from every position on the board of dim 5 for the first 3 rows (0.5% marks)" | tee -a $out
  echo " dim = 5: 304,0,56,0,304,0,56,0,56,0,56,0,64,0,56)" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "knight1.scala" "knight1_test3b.scala") 
  then
     END=$(date +%s)
     DIFF=$(( $END - $START ))
     #echo " This test ran for $DIFF seconds." | tee -a $out  
     echo -e "  --> success\n" | tee -a $out
     marks=$(( marks + 0.5 ))
  else
     END=$(date +%s)
     DIFF=$(( $END - $START ))
     echo " This test ran for $DIFF seconds." | tee -a $out 
     echo -e "  --> ONE TEST FAILED\n" | tee -a $out
  fi
fi



if [ $tsts -eq 0 ]
then
  echo " enum_tours(5, List((0,2)) ) => 56 tours? and all correct?" | tee -a $out
  echo " enum_tours(5, List((0,0)) ) => 304 tours? and all correct?" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "knight1.scala" "knight1_test3c.scala") 
  then
     END=$(date +%s)
     DIFF=$(( $END - $START ))
     #echo " This test ran for $DIFF seconds." | tee -a $out 
     echo -e "  --> success\n" | tee -a $out
     marks=$(( marks + 1.0 ))
  else
     END=$(date +%s)
     DIFF=$(( $END - $START ))
     echo " This test ran for $DIFF seconds." | tee -a $out 
     echo -e "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi


## final marks
echo -e "Overall mark for the Preliminary Part 4 (Scala)" | tee -a $out
printf " %0.1f\n" $marks | tee -a $out



