// Part 2 about Alcohol-Consumption Worldwide
//============================================

object CW6b {

import io.Source
import scala.util._

def get_csv_page(url: String) : List[String] = 
  Source.fromURL(url)("ISO-8859-1").getLines.toList

def get_csv_file(file: String) : List[String] = 
  Source.fromFile(file)("ISO-8859-1").getLines.toList


val url_alcohol = 
  "https://raw.githubusercontent.com/fivethirtyeight/data/master/alcohol-consumption/drinks.csv"

val file_population = 
  "population.csv"

get_csv_page(url_alcohol)
get_csv_file(file_population)

get_csv_page(url_alcohol).size
get_csv_file(file_population).size

val alcs = get_csv_page(url_alcohol)
val pops = get_csv_file(file_population)


def process_alcs(lines: List[String]) : List[(String, Double)] =
  for (l <- lines) yield {
    val entries = l.split(",").toList 
    (entries(0), entries(4).toDouble) 
  }

def process_pops(lines: List[String]) : Map[String, Long] =
  (for (l <- lines) yield {
    val entries = l.split(",").toList 
    (entries(0), entries(1).toLong)
  }).toMap


def sorted_country_consumption() : List[(String, Long)] = {
  val alcs2 = process_alcs(alcs.drop(1))
  val pops2 = process_pops(pops.drop(1))
  val cons_list = 
    for ((cname, cons) <- alcs2; 
	 if pops2.isDefinedAt(cname)) yield (cname, (cons * pops2(cname)).toLong)
  cons_list.sortBy(_._2).reverse
}

sorted_country_consumption().take(10)
sorted_country_consumption().size

def percentage(n: Int) : (Long, Long, Double) = {
  val cons_list = sorted_country_consumption()
  val sum_n = cons_list.take(n).map(_._2).sum
  val sum_all = cons_list.map(_._2).sum
  val perc = (sum_n.toDouble / sum_all.toDouble) * 100.0
  (sum_all, sum_n, perc)
}


percentage(10)
percentage(164)

}
