#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 7 Part 3.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for CW7 part 3
marks=$(( 0 ))


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo "danube.scala does not contain vars, returns etc?" | tee -a $out  

if (scala_vars danube.scala)
then
  echo "  --> test failed" | tee -a $out  
  tsts0=$(( 1 ))
else
  echo -e "  --> success" | tee -a $out  
  tsts0=$(( 0 )) 
fi


### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo "danube.scala runs?" | tee -a $out  

  if (scala_compile danube.scala)
  then
    echo -e "  --> success" | tee -a $out  
    tsts=$(( 0 ))
  else
    echo "  --> scala danube.scala did not run successfully" | tee -a $out  
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### danube groupById test

if [ $tsts -eq 0 ]
then
  echo "  val ls1 = List((\"1\", \"a\"), (\"2\", \"a\"), (\"1\", \"c\"), (\"2\", \"a\"), (\"1\", \"c\"))" | tee -a $out
  echo "  val ls2 = List((\"1\", \"a\"), (\"1\", \"b\"), (\"2\", \"x\"), (\"3\", \"a\"), (\"2\", \"y\"), (\"3\", \"c\"))" | tee -a $out
  echo "  groupById(ls1, Map()) == Map(1 -> List(c, c, a), 2 -> List(a, a))" | tee -a $out
  echo "  groupById(ls2, Map()) == Map(1 -> List(b, a), 2 -> List(x, y), 3 -> List(c, a))" | tee -a $out
  echo "      where the order in the lists is unimportant" | tee -a $out
  echo "  val ls3 = (1 to 1000).map(_.toString).toList" | tee -a $out
  echo "  val ls4 = ls3 zip ls3.tail" | tee -a $out
  echo "  val ls5 = ls4 ::: ls4.reverse" | tee -a $out
  echo "  groupById(ls5, Map()) == Map(1 -> List(2,2), 2 -> List(3,3), ....)" | tee -a $out

  if (scala_assert "danube.scala" "danube_test3.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> test failed" | tee -a $out
  fi
fi

### danube favourites tests

if [ $tsts -eq 0 ]
then
  echo "  val good_ratings = process_ratings(ratings)" | tee -a $out
  echo "  val ratings_map = groupById(good_ratings, Map())" | tee -a $out
  echo "  favourites(ratings_map, \"912\").length  == 80 " | tee -a $out
  echo "  favourites(ratings_map, \"858\").length  == 158 " | tee -a $out
  echo "  favourites(ratings_map, \"260\").length  == 201 " | tee -a $out  

  if (scala_assert "danube.scala" "danube_test4.scala") 
  then
    echo "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi

### danube suggestions tests

if [ $tsts -eq 0 ]
then
  echo "  val good_ratings = process_ratings(ratings)" | tee -a $out
  echo "  val ratings_map = groupById(good_ratings, Map())" | tee -a $out
  echo "  suggestions(ratings_map, \"912\").length  == 4110 " | tee -a $out
  echo "  suggestions(ratings_map, \"858\").length  == 4883 " | tee -a $out
  echo "  suggestions(ratings_map, \"260\").length  == 4970 " | tee -a $out  

  if (scala_assert "danube.scala" "danube_test5.scala") 
  then
    echo "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi

### danube recommendation tests

if [ $tsts -eq 0 ]
then
  echo "  recommendations(ratings_map, movies_map, \"1\").length  == 2 " | tee -a $out
  echo "  recommendations(ratings_map, movies_map, \"2\").length  == 2 " | tee -a $out
  echo "  recommendations(ratings_map, movies_map, \"3\").length  == 2 " | tee -a $out
  echo "  recommendations(ratings_map, movies_map, \"4\").length  == 0 " | tee -a $out
  echo "  recommendations(ratings_map, movies_map, \"5\").length  == 2 " | tee -a $out

  if (scala_assert "danube.scala" "danube_test6.scala") 
  then
    echo "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi


## final marks
echo "Overall mark for CW 7, Part 3" | tee -a $out
echo "$marks" | tee -a $out

