
import CW7b._

// first test 

def urban_groupById(ratings: List[(String, String)], 
              m: Map[String, List[String]]) : Map[String, List[String]] = ratings match {
  case Nil => m
  case (id, mov) :: rest => {
    val old_ratings = m.getOrElse (id, Nil)
    val new_ratings = m + (id -> (mov :: old_ratings))
    urban_groupById(rest, new_ratings)
  }
}
//def urban_groupById(ratings: List[(String, String)]) = 
//  ratings.groupBy(_._1).view.mapValues(_.map(_._2)).toMap 

def urban_get_csv_file(name: String) : List[String] = {
  import io.Source
  import scala.util._
  val csv = Source.fromFile(name)("ISO-8859-1")
  csv.mkString.split("\n").toList.drop(1)
}

def urban_process_ratings(lines: List[String]) : List[(String, String)] = {
  for (cols <- lines.map(_.split(",").toList); 
       if (cols(2).toInt >= 4)) yield (cols(0), cols(1))  
}

def urban_process_movies(lines: List[String]) : List[(String, String)] = {
  for (cols <- lines.map(_.split(",").toList)) yield (cols(0), cols(1))  
}


val urban_good_ratings = urban_process_ratings(urban_get_csv_file("ratings.csv"))
val urban_movie_names = urban_process_movies(urban_get_csv_file("movies.csv"))

val urban_movie_names_map = urban_movie_names.toMap
val urban_ratings_map = urban_groupById(urban_good_ratings, Map())
//val urban_ratings_map = groupById(urban_good_ratings, Map())

val urban_ratings_map2 =  for ((k, v) <- urban_ratings_map) yield (k, v.take(2))

assert(most_recommended(urban_ratings_map2, urban_movie_names_map).take(3) == 
       List(("M*A*S*H (a.k.a. MASH) (1970)",15), 
            ("Star Trek: First Contact (1996)",10), 
            ("Inception (2010)",9)))

