#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo "Below is the feedback for your submission docdiff.scala" >> $out
echo "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo "docdiff.scala does not contain vars, returns etc?" >> $out

if (scala_vars docdiff.scala)
then
  echo "  --> fail (make triple-sure your program conforms to the required format)" >> $out
  tsts0=$(( 0 ))
else
  echo "  --> success" >> $out
  tsts0=$(( 0 )) 
fi

### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo "docdiff.scala runs?" >> $out

  if (scala_compile docdiff.scala)
  then
    echo "  --> success" >> $out
    tsts=$(( 0 ))
  else
    echo "  --> scala did not run docdiff.scala" >> $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### docdiff clean tests

if [ $tsts -eq 0 ]
then
  echo "docdiff.scala tests:" >> $out
  echo "  clean(\"ab a abc\") == List(\"ab\", \"a\", \"abc\")" >> $out
  echo "  clean(\"ab*a abc1\") == List(\"ab\", \"a\", \"abc1\")" >> $out

  if (scala_assert "docdiff.scala" "docdiff_test1.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> one of the tests failed" >> $out
  fi
fi

### docdiff occurrences tests

if [ $tsts -eq 0 ]
then
  echo "  occurrences(List(\"a\", \"b\", \"b\", \"c\", \"d\")) == " >> $out
  echo "      Map(\"a\" -> 1, \"b\" -> 2, \"c\" -> 1, \"d\" -> 1)" >> $out
  echo "  " >> $out
  echo "  occurrences(List(\"d\", \"b\", \"d\", \"b\", \"d\")) == " >> $out
  echo "      Map(\"d\" -> 3, \"b\" -> 2)" >> $out

  if (scala_assert "docdiff.scala" "docdiff_test2.scala") 
  then
    echo "  --> success" >> $out
  else
    echo "  --> one of the tests failed" >> $out
  fi
fi

### docdiff prod tests

if [ $tsts -eq 0 ]
then
  echo "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" >> $out
  echo "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" >> $out
  echo "  " >> $out
  echo "  prod(l1, l2) == 7 " >> $out
  echo "  prod(l1, l1) == 7 " >> $out
  echo "  prod(l2, l2) == 13 " >> $out

  if (scala_assert "docdiff.scala" "docdiff_test3.scala") 
  then
    echo "  --> success" >> $out
  else
    echo "  --> one of the tests failed" >> $out
  fi
fi

### docdiff overlap tests

if [ $tsts -eq 0 ]
then
  echo "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" >> $out
  echo "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" >> $out
  echo "  " >> $out
  echo "  overlap(l1, l2) == 0.5384615384615384 " >> $out
  echo "  overlap(l1, l1) == 1.0 " >> $out
  echo "  overlap(l2, l2) == 1.0 " >> $out

  if (scala_assert "docdiff.scala" "docdiff_test4.scala") 
  then
    echo "  --> success" >> $out
  else
    echo "  --> one of the tests failed" >> $out
  fi
fi
