#!/bin/bash

# to make the script fail safely
set -euo pipefail

out=${1:-output}

echo "" > $out


echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 8 Part 1.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for CW8 part 1
marks=$(( 0 ))

# compilation tests

function scala_compile {
    (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, return, ListBuffer test
#
echo "re.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars re.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "re.scala runs?" | tee -a $out

  if (scala_compile re.scala)
  then
    echo "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala re.scala did not run successfully" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi



if [ $tsts1 -eq 0 ]
then
  echo " nullable(ZERO) == false" | tee -a $out
  echo " nullable(ONE) == true" | tee -a $out
  echo " nullable(CHAR('a')) == false" | tee -a $out
  echo " nullable(ZERO | ONE) == true" | tee -a $out
  echo " nullable(ZERO | CHAR('a')) == false" | tee -a $out
  echo " nullable(ONE ~  ONE) == true" | tee -a $out
  echo " nullable(ONE ~ CHAR('a')) == false" | tee -a $out
  echo " nullable(STAR(ZERO)) == true" | tee -a $out
  
  if (scala_assert "re.scala" "re1a_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " der('a', ZERO | ONE) == (ZERO | ZERO)" | tee -a $out
  echo " der('a', (CHAR('a') | ONE) ~ CHAR('a')) == ALT((ONE | ZERO) ~ CHAR('a'), ONE)" | tee -a $out
  echo " der('a', (CHAR('a') | CHAR('a')) ~ CHAR('a')) == (ONE | ONE) ~ CHAR('a')" | tee -a $out
  echo " der('a', STAR(CHAR('a'))) == (ONE ~ STAR(CHAR('a')))" | tee -a $out
  echo " der('b', STAR(CHAR('a'))) == (ZERO ~ STAR(CHAR('a')))" | tee -a $out
  
  if (scala_assert "re.scala" "re1b_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " simp(ZERO | ONE) == ONE" | tee -a $out
  echo " simp(STAR(ZERO | ONE)) == STAR(ZERO | ONE)" | tee -a $out
  echo " simp(ONE ~ (ONE ~ (ONE ~ CHAR('a')))) == CHAR('a')" | tee -a $out
  echo " simp(ONE ~ (ONE ~ (ONE ~ ZERO))) == ZERO" | tee -a $out
  echo " simp(ALT(ONE ~ (ONE ~ (ONE ~ ZERO)), CHAR('a'))) == CHAR('a')" | tee -a $out
  echo " simp(CHAR('a') | CHAR('a')) == CHAR('a')" | tee -a $out
  echo " simp(CHAR('a') ~ CHAR('a')) == CHAR('a') ~ CHAR('a')" | tee -a $out
  echo " simp(ONE | CHAR('a')) == (ONE | CHAR('a'))" | tee -a $out
  echo " simp(ALT((CHAR('a') | ZERO) ~ ONE," | tee -a $out
  echo "          ((ONE | CHAR('b')) | CHAR('c')) ~ (CHAR('d') ~ ZERO))) == CHAR('a')" | tee -a $out
  echo " simp((ZERO | ((ZERO | ZERO) | (ZERO | ZERO))) ~ ((ONE | ZERO) | ONE ) ~ (CHAR('a'))) == ZERO" | tee -a $out
  echo " simp(ALT(ONE | ONE, ONE | ONE)) == ONE" | tee -a $out
  echo " simp(ALT(ZERO | CHAR('a'), CHAR('a') | ZERO)) == CHAR('a')" | tee -a $out
  echo " simp(Iterator.iterate(ONE:Rexp)(r => SEQ(r, ONE | ONE)).drop(50).next) == ONE" | tee -a $out
  echo "    the Iterator produces the rexp" | tee -a $out
  echo "" | tee -a $out
  echo "      SEQ(SEQ(SEQ(..., ONE | ONE) , ONE | ONE), ONE | ONE)" | tee -a $out
  echo "" | tee -a $out
  echo "    where SEQ is nested 50 times." | tee -a $out
  if (scala_assert "re.scala" "re1c_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 2 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi


if [ $tsts1 -eq 0 ]
then
  echo " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" | tee -a $out
  echo " ders((\"a\" * 5).toList,EVIL) == SEQ(SEQ(STAR(CHAR('a')),STAR(STAR(CHAR('a')))),CHAR('b'))" | tee -a $out
  echo " ders(List('b'),EVIL) == ONE" | tee -a $out
  echo " ders(List('b','b'),EVIL) == ZERO" | tee -a $out
  echo " matcher(EVIL, \"a\" * 5 ++ \"b\") == true" | tee -a $out
  echo " matcher(EVIL, \"a\" * 50 ++ \"b\") == true" | tee -a $out
  echo " matcher(EVIL, \"a\" * 50) == false" | tee -a $out
  echo " matcher(EVIL, \"b\") == true" | tee -a $out
  echo " matcher(EVIL, \"bb\") == false" | tee -a $out
  echo " matcher(\"abc\", \"abc\") == true" | tee -a $out
  echo " matcher((\"ab\" | \"a\") ~ (ONE | \"bc\"), \"abc\") == true" | tee -a $out
  echo " matcher(ONE, \"\") == true" | tee -a $out
  echo " matcher(ZERO, \"\") == false" | tee -a $out
  echo " matcher(ONE | CHAR('a'), \"\") == true" | tee -a $out
  echo " matcher(ONE | CHAR('a'), \"a\") == true" | tee -a $out
  
  if (scala_assert "re.scala" "re1d_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi


if [ $tsts1 -eq 0 ]
then
  echo " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" | tee -a $out  
  echo " size(der('a', der('a', EVIL))) == 28" | tee -a $out
  echo " size(der('a', der('a', der('a', EVIL)))) == 58" | tee -a $out
  echo " size(ders(\"aaaaaa\".toList, EVIL)) == 8" | tee -a $out
  echo " size(ders((\"a\" * 50).toList, EVIL)) == 8" | tee -a $out
  
  if (scala_assert "re.scala" "re1e_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi


## final marks
echo "Overall mark for CW 8, Part 1" | tee -a $out
echo "$marks" | tee -a $out


