#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "for the Preliminary Part of Assignemnt 7.  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out
echo -e "" >> $out

echo -e "Below is the feedback for your submission docdiff.scala" >> $out
echo -e "" >> $out

# marks for CW7 parts 1 + 2
marks=$(( 0 ))


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|ListBuffer|mutable' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo -e "docdiff.scala does not contain vars, returns etc?" |  tee -a $out

if (scala_vars docdiff.scala)
then
  echo -e "  --> FAIL (make triple-sure your program conforms to the required format)\n" | tee -a $out  
  tsts0=$(( 1 ))
else
  echo -e "  --> success" |  tee -a $out
  tsts0=$(( 0 )) 
fi

### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo -e "docdiff.scala runs?" |  tee -a $out

  if (scala_compile docdiff.scala)
  then
    echo -e "  --> success" |  tee -a $out
    tsts=$(( 0 ))
  else
    echo -e "  --> scala did not run docdiff.scala" |  tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### docdiff clean tests

if [ $tsts -eq 0 ]
then
  echo -e "docdiff.scala tests:" |  tee -a $out
  echo -e "  clean(\"ab a abc\") == List(\"ab\", \"a\", \"abc\")" |  tee -a $out
  echo -e "  clean(\"ab*a abc1\") == List(\"ab\", \"a\", \"abc1\")" |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test1.scala")
  then
      echo -e "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi

### docdiff occurrences tests

if [ $tsts -eq 0 ]
then
  echo -e "  occurrences(List(\"a\", \"b\", \"b\", \"c\", \"d\")) == " |  tee -a $out
  echo -e "      Map(\"a\" -> 1, \"b\" -> 2, \"c\" -> 1, \"d\" -> 1)" |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  occurrences(List(\"d\", \"b\", \"d\", \"b\", \"d\")) == " |  tee -a $out
  echo -e "      Map(\"d\" -> 3, \"b\" -> 2)" |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  occurrences(Nil) == Map() " |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  occurrences(List(\"b\", \"b\", \"b\", \"b\", \"b\")) == Map(\"b\" -> 5)" |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test2.scala") 
  then
      echo -e "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi

### docdiff prod tests

if [ $tsts -eq 0 ]
then
  echo -e "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" |  tee -a $out
  echo -e "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  prod(l1, l2) == 7 " |  tee -a $out
  echo -e "  prod(l1, l1) == 7 " |  tee -a $out
  echo -e "  prod(l2, l2) == 13 " |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  val l3 = List(\"1\", \"2\", \"3\", \"4\", \"5\")" |  tee -a $out
  echo -e "  prod(l1, l3) == 0 " |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test3.scala") 
  then
      echo -e "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi

### docdiff overlap tests

if [ $tsts -eq 0 ]
then
  echo -e "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" |  tee -a $out
  echo -e "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  overlap(l1, l2) == 0.5384615384615384 " |  tee -a $out
  echo -e "  overlap(l1, l1) == 1.0 " |  tee -a $out
  echo -e "  overlap(l2, l2) == 1.0 " |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test4.scala") 
  then
      echo -e "  --> success" |  tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi


## final marks
echo -e "Overall mark for the Preliminary Part" | tee -a $out
echo -e " $marks" | tee -a $out

