#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out


echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 10 Part 2.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for CW10 part 2
marks=$(( 0 ))

# compilation tests

function scala_compile {
    (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}


# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}



# var, return, ListBuffer test
#
echo "bfc.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars bfc.scala)
then
  echo "  --> FAIL (make triple-sure your program conforms to the required format)" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "bfc.scala runs?" | tee -a $out

  if (scala_compile bfc.scala)
  then
    echo "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo "  --> SCALA DID NOT RUN BFC.SCALA\n" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


### bfc5 test

if [ $tsts1 -eq 0 ]
then
  echo -e " val p1 = \"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++<<]>>++<<----------[+>.>.<+<]\"\"\"" | tee -a $out
  echo -e " jtable(p1) == Map(69 -> 61, 5 -> 20, 60 -> 70, 27 -> 44, 43 -> 28, 19 -> 6)" | tee -a $out  
  echo -e " val p2 = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---.+++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " jtable(p2) == Map(14 -> 34, 33 -> 15, 45 -> 44, 48 -> 9, 43 -> 46, 8 -> 49)" | tee -a $out
  echo -e " run2(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run2(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run2(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo -e " run2(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run2(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  
  if (scala_assert "bfc.scala" "bf_test5.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi


### bfc6 test

if [ $tsts1 -eq 0 ]
then
  echo -e " optimise(load_bff(\"benchmark.bf\")).length == 181" | tee -a $out
  echo -e " optimise(load_bff(\"mandelbrot.bf\")).length == 11203" | tee -a $out  
  echo -e " run3(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run3(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run3(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo -e " run3(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run3(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  
  if (scala_assert "bfc.scala" "bf_test6.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi

### bfc7 test

if [ $tsts1 -eq 0 ]
then
  echo -e " combine(optimise(load_bff(\"benchmark.bf\"))).length == 134" | tee -a $out
  echo -e " combine(optimise(load_bff(\"mandelbrot.bf\"))).length == 6509" | tee -a $out
  echo -e " run4(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo -e " run4(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo -e " run4(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo -e " run4(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" | tee -a $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  echo -e " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo -e "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo -e " run4(hello, Map()) == " | tee -a $out
  echo -e "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  
  if (scala_assert "bfc.scala" "bf_test7.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 2 ))
  else
      echo "  --> \n ONE TEST FAILED\n" | tee -a $out
  fi
fi


## final marks
echo "Overall mark for CW 10, Part 2" | tee -a $out
echo "$marks" | tee -a $out

