#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out


echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 8 Part 2.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for CW8 part 2
marks=$(( 0 ))

# compilation tests

function scala_compile {
    (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}


# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}



# var, return, ListBuffer test
#
echo "bf.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars bf.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "bf.scala runs?" | tee -a $out

  if (scala_compile bf.scala)
  then
    echo "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala bf.scala did not run successfully" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi



if [ $tsts1 -eq 0 ]
then
  echo " sread(Map(), 2) == 0" | tee -a $out
  echo " sread(Map(2 -> 1), 2) == 1" | tee -a $out  
  echo " write(Map(), 1, 2) == Map(1 -> 2)" | tee -a $out
  echo " write(Map(1 -> 0), 1, 2) == Map(1 -> 2)" | tee -a $out
  
  if (scala_assert "bf.scala" "bf1a_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> test failed" | tee -a $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
    echo " jumpRight(\"[******]***\", 1, 0) == 8" | tee -a $out
    echo " jumpRight(\"[**[*]*]***\", 1, 0) == 8" | tee -a $out
    echo " jumpRight(\"[**[*]*]***\", 1, 0) == 8" | tee -a $out
    echo " jumpRight(\"[**[***]***\", 1, 0) == 11" | tee -a $out
    echo " jumpRight(\"[*[][]*]***\", 1, 0) == 8" | tee -a $out
    echo " jumpLeft(\"[******]***\", 6, 0) == 1" | tee -a $out
    echo " jumpLeft(\"[******]***\", 7, 0) == -1" | tee -a $out
    echo " jumpLeft(\"[*[][]*]***\", 6, 0) == 1" | tee -a $out
  
  if (scala_assert "bf.scala" "bf1b_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo " start(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" | tee -a $out
  echo " start(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" | tee -a $out
  echo " start(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" | tee -a $out
  echo " val hello = \"\"\"++++++++[>++++[>++>+++>+++>+<<<<-]>+>+>->>+[<]<-]>>.>---." | tee -a $out
  echo "               +++++++..+++.>>.<-.<.+++.------.--------.>>+.>++.\"\"\"" | tee -a $out
  echo " start(hello, Map()) == " | tee -a $out
  echo "       Map(0 -> 0, 5 -> 33, 1 -> 0, 6 -> 10, 2 -> 72, 3 -> 100, 4 -> 87)" | tee -a $out
  echo " start(\"+++++[->++++++++++<]>--<+++[->>++++++++++<<]>>++<<----------[+>.>.<+<]\", Map()) == " | tee -a $out
  echo "       Map(0 -> 0, 1 -> 58, 2 -> 32)" | tee -a $out
  
  if (scala_assert "bf.scala" "bf1c_test.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 2 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi


## final marks
echo "Overall mark for CW 8, Part 2" | tee -a $out
echo "$marks" | tee -a $out

