// Part 1 about the 3n+1 conceture
//=================================


//(1) Complete the collatz function below. It should
//    recursively calculate the number of steps needed 
//    until the collatz series reaches the number 1.
//    If needed you can use an auxilary function that
//    performs the recursion. The function should expect
//    arguments in the range of 1 to 1 Million.


def collatz(n: Long): Int =
  if (n == 1) 1 else
    if (n % 2 == 0) (1 + collatz(n / 2)) else 
      (1 + collatz(3 * n + 1))


//(2)  Complete the collatz bound function below. It should
//     calculuate how many steps are needed for each number 
//     from 1 upto a bound and then produce the maximum number of
//     steps and the corresponding number that needs that many 
//     steps. You should expect bounds in the range of 1
//     upto 1 million. 

def collatz_max(bnd: Int): (Int, Int) = {
  val all = for (i <- (1 to bnd).toList) yield collatz(i)
  val max = all.max
  (all.indexOf(max) + 1, max)
}


// some testing harness
/*
val bnds = List(2, 10, 100, 1000, 10000, 100000, 77000, 90000, 1000000, 5000000)

for (bnd <- bnds) {
  val (max, steps) = collatz_max(bnd)
  println(s"In the range of 1 - ${bnd} the number ${max} needs the maximum steps of ${steps}")
}
*/

//val all = for (i <- (1 to 100000).toList) yield collatz1(i)
//println(all.sorted.reverse.take(10))



