import scala.util._
type Pos = (Int, Int)


def print_board(n: Int)(steps: List[Pos]): Unit = {
  for (i <- 0 until n) {
    for (j <- 0 until n) {
      print(f"${steps.indexOf((i, j))}%3.0f ")
    }
    println
  } 
  //readLine()
  System.exit(0)
}

def add_pair(x: Pos)(y: Pos) = 
  (x._1 + y._1, x._2 + y._2)

def is_legal(n: Int)(x: Pos) = 
  0 <= x._1 && 0 <= x._2 && x._1 < n && x._2 < n

def moves(n: Int)(x: Pos): List[Pos] = {
  List((1, 2),(2, 1),(2, -1),(1, -2),
       (-1, -2),(-2, -1),(-2, 1),(-1, 2)).map(add_pair(x)).filter(is_legal(n))
}

def ordered_moves(n: Int)(steps: List[Pos])(x : Pos): List[Pos] = 
  moves(n)(x).sortBy((x: Pos) => moves(n)(x).filterNot(steps.contains(_)).length)

moves(8)(1,3)
ordered_moves(8)(Nil)(1,3)
ordered_moves(8)(List((2, 4), (2, 6)))(1,3)

// non-circle tour
def tour(n: Int)(steps: List[Pos]): Unit = {
  if (steps.length ==  n * n)
    print_board(n)(steps)
  else 
    for (x <- moves(n)(steps.head); if (!steps.contains(x))) tour(n)(x :: steps)
}

val n = 8
println(s"simple tour: n = $n")

for (i <- 0 until n; j <- 0 until n) tour(n)(List((i, j))) 
