#!/bin/bash
set -euo pipefail

out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission of shogun.scala" >> $out
echo -e "" >> $out
#echo -e "!! Important: !!" >> $out
#echo -e "Because of limitations with our testing infrastructure, we can only" >> $out
#echo -e "let code run for 10 seconds and then have to kill it. This might" >> $out
#echo -e "mean your code is correct, but still marked as Fail. Remember" >> $out
#echo -e "you can test your code on your own machine and benchmark it" >> $out
#echo -e "against the reference implementation." >> $out
#echo -e "" >> $out

# compilation tests

function scala_compile {
  (scala-cli compile -color never -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (scala-cli --server=false --java-opt -Xmx1g -i project.scala "$1" "$2" -e "urbanmain()" 2> /dev/null 1> /dev/null)
}

# purity test
function scala_vars {
   (sed 's/immutable/ok/g' c$out > cb$out;
    egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' cb$out 2> /dev/null 1> /dev/null)
}


# compilation test

  
echo -e "shogun.scala runs?" >> $out

if (scala_compile shogun.scala)
then
    echo -e "  --> passed" >> $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN SHOGUN.SCALA\n" >> $out
    tsts1=$(( 1 )) 
fi


# shogun: purity test

if [ $tsts1 -eq 0 ]
then  
    echo -e "shogun.scala does not contain vars, returns etc?" >> $out

    if (scala_vars shogun.scala)
    then
	echo -e "  --> FAIL (make triple-sure your program conforms to the required format)" >> $out  
	tsts1=$(( 1 ))
    else
	echo -e "  --> passed" >> $out
	tsts1=$(( 0 )) 
    fi
fi    


### shogun eval test

if [ $tsts1 -eq 0 ]
then
    echo -e "  val pw_a = Pawn(4, Wht, (4,4)) " >> $out
    echo -e "  eval(pw_a, U,  4, b_init) == Set(Pawn(4,Wht,(4,8)))" >> $out
    echo -e "  eval(pw_a, U,  3, b_init) == Set(Pawn(4,Wht,(4,7)))" >> $out
    echo -e "  eval(pw_a, RU, 4, b_init) == Set(Pawn(4,Wht,(6,6)), Pawn(4,Wht,(4,8)), " >> $out
    echo -e "                                   Pawn(4,Wht,(5,7)), Pawn(4,Wht,(7,5)), " >> $out
    echo -e "                                   Pawn(4,Wht,(8,4)))" >> $out
    echo -e "  " >> $out
    echo -e "  val pw_b = Pawn(4, Red, (4,4))" >> $out
    echo -e "  eval(pw_b, RU, 4, b_init) == Set(Pawn(4,Red,(8,4)), Pawn(4,Red,(7,5)), " >> $out
    echo -e "                                   Pawn(4,Red,(6,6)), Pawn(4,Red,(5,7)))" >> $out
    echo -e "  " >> $out

    if (scala_assert "shogun.scala" "shogun_test1.scala")
    then
        echo -e "  --> success" >> $out
    else
        echo -e "  --> \n ONE TEST FAILED\n" >> $out
    fi
fi

### shogun all_moves test

if [ $tsts1 -eq 0 ]
then
  echo -e " val pw_c = Pawn(2, Wht, (4,4))" >> $out
  echo -e " val pw_d = Pawn(3, Red, (4,4))" >> $out
  echo -e " all_moves(pw_c, b_init) == " >> $out
  echo -e "    Set(Pawn(2,Wht,(3,5)), Pawn(2,Wht,(2,4)), Pawn(2,Wht,(3,3)), Pawn(2,Wht,(5,5))," >> $out
  echo -e "        Pawn(2,Wht,(6,4)), Pawn(2,Wht,(4,6)), Pawn(2,Wht,(4,2)), Pawn(2,Wht,(5,3)))" >> $out
  echo -e " all_moves(pw_d, b_init) == " >> $out
  echo -e "    Set(Pawn(3,Red,(4,7)), Pawn(3,Red,(5,2)), Pawn(3,Red,(3,2)), Pawn(3,Red,(1,4))," >> $out
  echo -e     "    Pawn(3,Red,(6,3)), Pawn(3,Red,(3,6)), Pawn(3,Red,(2,5)), Pawn(3,Red,(2,3)), " >> $out
  echo -e "        Pawn(3,Red,(4,1)), Pawn(3,Red,(5,6)), Pawn(3,Red,(7,4)), Pawn(3,Red,(6,5))))" >> $out

  
  if (scala_assert "shogun.scala" "shogun_test2.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


### attacked test

if [ $tsts1 -eq 0 ]
then
  echo -e " val b2 = Board(Set(King(2, Red, (4,2)), King(2, Wht, (7,1))," >> $out
  echo -e "                    Pawn(3, Red, (6,1)), Pawn(2, Wht, (8,4))," >> $out
  echo -e "                    Pawn(4, Red, (4,4)), Pawn(2, Wht, (4,1))," >> $out
  echo -e "                    Pawn(4, Red, (5,3)), Pawn(3, Wht, (8,7))," >> $out
  echo -e "                    Pawn(3, Red, (6,5))))" >> $out
  echo -e " attacked(Red, b2) == Set(Pawn(2,Wht,(8,4)), King(2,Wht,(7,1)))" >> $out
  echo -e " attacked(Wht, b2) == Set(Pawn(3,Red,(6,1)))" >> $out
  echo -e " attacked(Wht, b_init) == Set()" >> $out
  echo -e " attacked(Red, b_init) == Set()" >> $out
  
  if (scala_assert "shogun.scala" "shogun_test3.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi

### attackedN test

if [ $tsts1 -eq 0 ]
then
  echo -e " attackedN(Pawn(2, Wht, (8,4)), b2) == 3" >> $out
  echo -e " attackedN(King(2, Wht, (7,1)), b2) == 1" >> $out
  echo -e " attackedN(Pawn(3, Red, (6,1)), b2) == 1" >> $out

  if (scala_assert "shogun.scala" "shogun_test4.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


### protectedN test

if [ $tsts1 -eq 0 ]
then
  echo -e " protectedN(Pawn(2, Wht, (8,4)), b2) == 1" >> $out
  echo -e " protectedN(Pawn(4, Red, (5,3)), b2) == 3" >> $out

  if (scala_assert "shogun.scala" "shogun_test5.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


# legal moves
if [ $tsts1 -eq 0 ]
then
  echo -e " Task 6: automated test cases not yet done" >> $out
fi

echo -e "" >> $out
echo -e "" >> $out

