import M4d._

//type Pos = (Int, Int)
//type Path = List[Pos]

def add_pair_urban(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal_urban(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves_urban(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair_urban(x))

def legal_moves_urban(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves_urban(x).filter(is_legal_urban(dim, path))

def correct_urban(dim: Int)(p: Path): Boolean = p match {
  case Nil => true
  case x::Nil => true
  case x::y::p => 
    if (legal_moves_urban(dim, p, y).contains(x)) correct_urban(dim)(y::p) else false
}

import scala.concurrent._
import scala.concurrent.duration._
import ExecutionContext.Implicits.global
import scala.language.postfixOps 

lazy val f = Future {

val ts70 = one_tour_pred(8, List((0, 0)), 40, x => x._1 < 5).get
assert(correct_urban(8)(ts70) == true)
}

Await.result(f, 32 second)

