#!/bin/bash
set -euo pipefail

out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission for drumb.scala" >> $out
echo -e "" >> $out

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo -e "drumb.scala does not contain vars, returns etc?" >> $out

if (scala_vars drumb.scala)
then
  echo -e "  --> FAIL (make triple-sure your program conforms to the required format)" >> $out
  tsts0=$(( 0 ))
else
  echo -e "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then 
  echo -e "drumb.scala runs?" >> $out

  if (scala_compile drumb.scala)
  then
    echo -e "  --> success" >> $out
    tsts=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN drumb.scala" >> $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### get january data

if [ $tsts -eq 0 ]
then
  echo -e "  get_january_data(\"GOOG\", 1980) == List()" >> $out
  echo -e "  get_january_data(\"GOOG\", 2010).head == \"2010-01-04,312.204773\"" >> $out

  if (scala_assert "drumb.scala" "drumb_test1.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### get first price

if [ $tsts -eq 0 ]
then
  echo -e "  get_first_price(\"GOOG\", 1980) == None" >> $out
  echo -e "  get_first_price(\"GOOG\", 2010) == Some(312.204773)" >> $out  

  if (scala_assert "drumb.scala" "drumb_test2.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### get prices tests

if [ $tsts -eq 0 ]
then
  echo -e "  get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012) ==" >> $out
  echo -e "       List(List(Some(311.349976), Some(20.544939))," >> $out 
  echo -e "            List(Some(300.222351), Some(31.638695))," >> $out 
  echo -e "            List(Some(330.555054), Some(39.478039)))" >> $out

  if (scala_assert "drumb.scala" "drumb_test3.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### get_delta_test

if [ $tsts -eq 0 ]
then
  echo -e "  get_delta(None, None) == None" >> $out
  echo -e "  get_delta(Some(50.0), None) == None" >> $out
  echo -e "  get_delta(None, Some(100.0)) == None" >> $out
  echo -e "  get_delta(Some(50.0), Some(100.0)) == Some(1.0)" >> $out

  if (scala_assert "drumb.scala" "drumb_test4.scala")
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi


### get_deltas_test

if [ $tsts -eq 0 ]
then
  echo -e "  get_deltas(get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)) == " >> $out
  echo -e "    List(List(Some(-0.03573991804411003), Some(0.539974575389325)), " >> $out
  echo -e "         List(Some(0.10103414222249969), Some(0.24777764141006836)))" >> $out
  echo -e "" >> $out
  echo -e "  get_deltas(get_prices(List(\"BIDU\"), 2004 to 2008)) == " >> $out
  echo -e "    List(List(None), List(None),                          " >> $out
  echo -e "         List(Some(0.9277165354330709)), List(Some(2.119679764725104))) " >> $out
  
  if (scala_assert "drumb.scala" "drumb_test5.scala") 
  then
     echo -e "  --> success" >> $out
  else
     echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi


### yield_tests

if [ $tsts -eq 0 ]
then
  echo -e "  val ds = get_deltas(get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012))" >> $out
  echo -e "  yearly_yield(get_deltas(ds, 100, 0)) == 125" >> $out
  echo -e "  yearly_yield(get_deltas(ds, 100, 1)) == 117" >> $out
  
  if (scala_assert "drumb.scala" "drumb_test6.scala") 
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi


### investment_test

if [ $tsts -eq 0 ]
then
  echo -e "  All results need to be in the range of -/+ 1% of the given values."   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2000, 100) == 100"   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2001, 100) == 27 "   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2002, 100) == 42 "   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2003, 100) == 27 "   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2004, 100) == 38 "   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2005, 100) == 113"   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2006, 100) == 254"   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2000 to 2007, 100) == 349"   >> $out
  echo -e "   investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 1990 to 2017, 100) == 11504"   >> $out
  
  
  if (scala_assert "drumb.scala" "drumb_test7.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

