// Basic Part about the 3n+1 conjecture
//==================================

// generate jar with
//   > scala -d collatz.jar  collatz.scala

object CW6a { // for purposes of generating a jar

def collatz(n: Long): Long =
  if (n == 1) 0 else
    if (n % 2 == 0) 1 + collatz(n / 2) else 
      1 + collatz(3 * n + 1)


def collatz_max(bnd: Long): (Long, Long) = {
  val all = for (i <- (1L to bnd)) yield (collatz(i), i)
  all.maxBy(_._1)
}

//collatz_max(1000000)
//collatz_max(10000000)
//collatz_max(100000000)

/* some test cases
val bnds = List(10, 100, 1000, 10000, 100000, 1000000)

for (bnd <- bnds) {
  val (steps, max) = collatz_max(bnd)
  println(s"In the range of 1 - ${bnd} the number ${max} needs the maximum steps of ${steps}")
}

*/

def is_pow(n: Long) : Boolean = (n & (n - 1)) == 0

def is_hard(n: Long) : Boolean = is_pow(3 * n + 1)

def last_odd(n: Long) : Long = 
  if (is_hard(n)) n else
    if (n % 2 == 0) last_odd(n / 2) else 
      last_odd(3 * n + 1)


//for (i <- 130 to 10000) println(s"$i: ${last_odd(i)}")
//for (i <- 1 to 100) println(s"$i: ${collatz(i)}")

}



