/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.OldHashMap;
import scala.collection.immutable.OldHashMap$;
import scala.collection.immutable.OldHashSet;
import scala.collection.immutable.OldHashSet$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public abstract class TrieIterator<T>
implements Iterator<T> {
    private final Iterable<T>[] elems;
    public int scala$collection$immutable$TrieIterator$$depth;
    public final Iterable<T>[][] scala$collection$immutable$TrieIterator$$arrayStack;
    public int[] scala$collection$immutable$TrieIterator$$posStack;
    public Iterable<T>[] scala$collection$immutable$TrieIterator$$arrayD;
    public int scala$collection$immutable$TrieIterator$$posD;
    public Iterator<T> scala$collection$immutable$TrieIterator$$subIter;

    public TrieIterator(Iterable<T>[] elems) {
        this.elems = elems;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.scala$collection$immutable$TrieIterator$$depth = this.initDepth();
        this.scala$collection$immutable$TrieIterator$$arrayStack = this.initArrayStack();
        this.scala$collection$immutable$TrieIterator$$posStack = this.initPosStack();
        this.scala$collection$immutable$TrieIterator$$arrayD = this.initArrayD();
        this.scala$collection$immutable$TrieIterator$$posD = this.initPosD();
        this.scala$collection$immutable$TrieIterator$$subIter = this.initSubIter();
    }

    public abstract T getElem(Object var1);

    public int initDepth() {
        return 0;
    }

    public Iterable<T>[][] initArrayStack() {
        return new Iterable[6][];
    }

    public int[] initPosStack() {
        return new int[6];
    }

    public Iterable<T>[] initArrayD() {
        return this.elems;
    }

    public int initPosD() {
        return 0;
    }

    public Iterator<T> initSubIter() {
        return null;
    }

    private Iterable<T>[] getElems(Iterable<T> x) {
        Serializable[] serializableArray;
        Iterable<T> iterable = x;
        if (iterable instanceof OldHashMap.HashTrieMap) {
            OldHashMap.HashTrieMap x2 = (OldHashMap.HashTrieMap)iterable;
            serializableArray = x2.elems();
        } else if (iterable instanceof OldHashSet.HashTrieSet) {
            OldHashSet.HashTrieSet x3 = (OldHashSet.HashTrieSet)iterable;
            serializableArray = x3.elems();
        } else {
            throw new MatchError(iterable);
        }
        return (Iterable[])serializableArray;
    }

    private Iterable<T>[] collisionToArray(Iterable<T> x2) {
        Serializable[] serializableArray;
        Iterable<T> iterable = x2;
        if (iterable instanceof OldHashMap.OldHashMapCollision1) {
            OldHashMap.OldHashMapCollision1 x3 = (OldHashMap.OldHashMapCollision1)iterable;
            serializableArray = (Serializable[])((IterableOnceOps)x3.kvs().map((Function1 & Serializable)x -> (OldHashMap)OldHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x})))).toArray(ClassTag$.MODULE$.apply(OldHashMap.class));
        } else if (iterable instanceof OldHashSet.OldHashSetCollision1) {
            OldHashSet.OldHashSetCollision1 x4 = (OldHashSet.OldHashSetCollision1)iterable;
            serializableArray = (OldHashSet[])((IterableOnceOps)x4.ks().map((Function1 & Serializable)x -> (OldHashSet)OldHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x})))).toArray(ClassTag$.MODULE$.apply(OldHashSet.class));
        } else {
            throw new MatchError(iterable);
        }
        return (Iterable[])serializableArray;
    }

    private boolean isTrie(Object x) {
        Object object = x;
        return object instanceof OldHashMap.HashTrieMap || object instanceof OldHashSet.HashTrieSet;
        {
        }
    }

    private boolean isContainer(Object x) {
        Object object = x;
        return object instanceof OldHashMap.OldHashMap1 || object instanceof OldHashSet.OldHashSet1;
        {
        }
    }

    public TrieIterator<T> dupIterator() {
        return new DupIterator(this.elems);
    }

    private TrieIterator<T> newIterator(Iterable<T>[] xs) {
        return new TrieIterator<T>(xs, this){
            private final /* synthetic */ TrieIterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(xs$1);
            }

            public final Object getElem(Object x) {
                return this.$outer.getElem(x);
            }
        };
    }

    private Tuple2<Iterator<T>, Object> iteratorWithSize(Iterable<T>[] arr) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])arr);
        return Tuple2$.MODULE$.apply(this.newIterator(arr), Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.size(), ClassTag$.MODULE$.apply(Integer.TYPE))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> arrayToIterators(Iterable<T>[] arr) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])arr);
        Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object, arr.length / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable[] fst = (Iterable[])tuple2._1();
        Iterable[] snd = (Iterable[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
        Iterable[] fst2 = (Iterable[])tuple22._1();
        Iterable[] snd2 = (Iterable[])tuple22._2();
        return Tuple2$.MODULE$.apply(this.iteratorWithSize(snd2), this.newIterator(fst2));
    }

    private Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> splitArray(Iterable<T>[] ad) {
        while (ad.length <= 1) {
            Iterable<T> iterable = ad[0];
            if (iterable instanceof OldHashMap.OldHashMapCollision1 || iterable instanceof OldHashSet.OldHashSetCollision1) {
                return this.arrayToIterators(this.collisionToArray(ad[0]));
            }
            ad = this.getElems(ad[0]);
        }
        return this.arrayToIterators(ad);
    }

    public boolean hasNext() {
        return this.scala$collection$immutable$TrieIterator$$subIter != null || this.scala$collection$immutable$TrieIterator$$depth >= 0;
    }

    public T next() throws NoSuchElementException {
        if (this.scala$collection$immutable$TrieIterator$$subIter != null) {
            Object el = this.scala$collection$immutable$TrieIterator$$subIter.next();
            if (!this.scala$collection$immutable$TrieIterator$$subIter.hasNext()) {
                this.scala$collection$immutable$TrieIterator$$subIter = null;
            }
            return (T)el;
        }
        return this.next0(this.scala$collection$immutable$TrieIterator$$arrayD, this.scala$collection$immutable$TrieIterator$$posD);
    }

    private T next0(Iterable<T>[] elems, int i) {
        Iterable<T> m;
        while (true) {
            if (i == elems.length - 1) {
                --this.scala$collection$immutable$TrieIterator$$depth;
                if (this.scala$collection$immutable$TrieIterator$$depth >= 0) {
                    this.scala$collection$immutable$TrieIterator$$arrayD = this.scala$collection$immutable$TrieIterator$$arrayStack[this.scala$collection$immutable$TrieIterator$$depth];
                    this.scala$collection$immutable$TrieIterator$$posD = this.scala$collection$immutable$TrieIterator$$posStack[this.scala$collection$immutable$TrieIterator$$depth];
                    this.scala$collection$immutable$TrieIterator$$arrayStack[this.scala$collection$immutable$TrieIterator$$depth] = null;
                } else {
                    this.scala$collection$immutable$TrieIterator$$arrayD = null;
                    this.scala$collection$immutable$TrieIterator$$posD = 0;
                }
            } else {
                ++this.scala$collection$immutable$TrieIterator$$posD;
            }
            m = elems[i];
            if (this.isContainer(m)) {
                return this.getElem(m);
            }
            if (!this.isTrie(m)) break;
            if (this.scala$collection$immutable$TrieIterator$$depth >= 0) {
                this.scala$collection$immutable$TrieIterator$$arrayStack[this.scala$collection$immutable$TrieIterator$$depth] = this.scala$collection$immutable$TrieIterator$$arrayD;
                this.scala$collection$immutable$TrieIterator$$posStack[this.scala$collection$immutable$TrieIterator$$depth] = this.scala$collection$immutable$TrieIterator$$posD;
            }
            ++this.scala$collection$immutable$TrieIterator$$depth;
            this.scala$collection$immutable$TrieIterator$$arrayD = this.getElems(m);
            this.scala$collection$immutable$TrieIterator$$posD = 0;
            Iterable<T>[] iterableArray = this.getElems(m);
            int n = 0;
            elems = iterableArray;
            i = n;
        }
        this.scala$collection$immutable$TrieIterator$$subIter = m.iterator();
        return this.next();
    }

    public Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> split() {
        if (this.scala$collection$immutable$TrieIterator$$arrayD != null && this.scala$collection$immutable$TrieIterator$$depth == 0 && this.scala$collection$immutable$TrieIterator$$posD == 0) {
            return this.splitArray(this.scala$collection$immutable$TrieIterator$$arrayD);
        }
        if (this.scala$collection$immutable$TrieIterator$$subIter != null) {
            ArrayBuffer buff = (ArrayBuffer)ArrayBuffer$.MODULE$.empty().$plus$plus$eq(this.scala$collection$immutable$TrieIterator$$subIter);
            this.scala$collection$immutable$TrieIterator$$subIter = null;
            return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)buff.iterator(), (Object)BoxesRunTime.boxToInteger((int)buff.length())), (Object)this);
        }
        if (this.scala$collection$immutable$TrieIterator$$depth > 0) {
            if (this.scala$collection$immutable$TrieIterator$$posStack[0] == this.scala$collection$immutable$TrieIterator$$arrayStack[0].length - 1) {
                Iterable[] iterableArray = new Iterable[1];
                Object object = Predef$.MODULE$.refArrayOps(this.scala$collection$immutable$TrieIterator$$arrayStack[0]);
                iterableArray[0] = (Iterable)ArrayOps$.MODULE$.last$extension(object);
                Iterable[] snd = iterableArray;
                int szsnd = snd[0].size();
                --this.scala$collection$immutable$TrieIterator$$depth;
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.scala$collection$immutable$TrieIterator$$arrayStack.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    this.scala$collection$immutable$TrieIterator$$arrayStack[i - 1] = this.scala$collection$immutable$TrieIterator$$arrayStack[i];
                });
                this.scala$collection$immutable$TrieIterator$$arrayStack[this.scala$collection$immutable$TrieIterator$$arrayStack.length - 1] = new Iterable[]{null};
                Object object2 = Predef$.MODULE$.intArrayOps(this.scala$collection$immutable$TrieIterator$$posStack);
                Object object3 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.tail$extension(object2));
                this.scala$collection$immutable$TrieIterator$$posStack = (int[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (Object)new int[]{0}, ClassTag$.MODULE$.apply(Integer.TYPE));
                return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(this.newIterator(snd), (Object)BoxesRunTime.boxToInteger((int)szsnd)), (Object)this);
            }
            Object object = Predef$.MODULE$.refArrayOps(this.scala$collection$immutable$TrieIterator$$arrayStack[0]);
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object, this.scala$collection$immutable$TrieIterator$$arrayStack[0].length - (this.scala$collection$immutable$TrieIterator$$arrayStack[0].length - this.scala$collection$immutable$TrieIterator$$posStack[0] + 1) / 2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable[] fst = (Iterable[])tuple2._1();
            Iterable[] snd = (Iterable[])tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
            Iterable[] fst2 = (Iterable[])tuple22._1();
            Iterable[] snd2 = (Iterable[])tuple22._2();
            this.scala$collection$immutable$TrieIterator$$arrayStack[0] = fst2;
            return Tuple2$.MODULE$.apply(this.iteratorWithSize(snd2), (Object)this);
        }
        if (this.scala$collection$immutable$TrieIterator$$posD == this.scala$collection$immutable$TrieIterator$$arrayD.length - 1) {
            Iterable<T> m = this.scala$collection$immutable$TrieIterator$$arrayD[this.scala$collection$immutable$TrieIterator$$posD];
            return this.arrayToIterators(this.isTrie(m) ? this.getElems(m) : this.collisionToArray(m));
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.scala$collection$immutable$TrieIterator$$arrayD);
        Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object, this.scala$collection$immutable$TrieIterator$$arrayD.length - (this.scala$collection$immutable$TrieIterator$$arrayD.length - this.scala$collection$immutable$TrieIterator$$posD + 1) / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable[] fst = (Iterable[])tuple2._1();
        Iterable[] snd = (Iterable[])tuple2._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
        Iterable[] fst3 = (Iterable[])tuple23._1();
        Iterable[] snd3 = (Iterable[])tuple23._2();
        this.scala$collection$immutable$TrieIterator$$arrayD = fst3;
        return Tuple2$.MODULE$.apply(this.iteratorWithSize(snd3), (Object)this);
    }

    public final class DupIterator
    extends TrieIterator<T> {
        public DupIterator(Iterable<T>[] xs) {
            if (TrieIterator.this == null) {
                throw new NullPointerException();
            }
            super(xs);
        }

        @Override
        public int initDepth() {
            return TrieIterator.this.scala$collection$immutable$TrieIterator$$depth;
        }

        @Override
        public Iterable<T>[][] initArrayStack() {
            return TrieIterator.this.scala$collection$immutable$TrieIterator$$arrayStack;
        }

        @Override
        public int[] initPosStack() {
            return TrieIterator.this.scala$collection$immutable$TrieIterator$$posStack;
        }

        @Override
        public Iterable<T>[] initArrayD() {
            return TrieIterator.this.scala$collection$immutable$TrieIterator$$arrayD;
        }

        @Override
        public int initPosD() {
            return TrieIterator.this.scala$collection$immutable$TrieIterator$$posD;
        }

        @Override
        public Iterator<T> initSubIter() {
            return TrieIterator.this.scala$collection$immutable$TrieIterator$$subIter;
        }

        @Override
        public final T getElem(Object x) {
            return TrieIterator.this.getElem(x);
        }

        public final /* synthetic */ TrieIterator scala$collection$immutable$TrieIterator$DupIterator$$$outer() {
            return TrieIterator.this;
        }
    }
}

