// Part 2 about finding a single tour for a board
//================================================

type Pos = (Int, Int)    // a position on a chessboard 
type Path = List[Pos]    // a path...a list of positions

def print_board(dim: Int, path: Path): Unit = {
  println
  for (i <- 0 until dim) {
    for (j <- 0 until dim) {
      print(f"${path.reverse.indexOf((i, j))}%3.0f ")
    }
    println
  } 
}

def add_pair(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair(x))

def legal_moves(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves(x).filter(is_legal(dim, path))


def first(xs: List[Pos], f: Pos => Option[Path]): Option[Path] = xs match {
  case Nil => None
  case x::xs => {
    val result = f(x)
    if (result.isDefined) result else first(xs, f)
  }
}

first(List((1, 0),(2, 0),(3, 0),(4, 0)), (x => if (x._1 > 3) Some(List(x)) else None))
first(List((1, 0),(2, 0),(3, 0)), (x => if (x._1 > 3) Some(List(x)) else None))



def first_tour(dim: Int, path: Path): Option[Path] = {
  if (path.length == dim * dim) Some(path)
  else
    first(legal_moves(dim, path, path.head), (x: Pos) => first_tour(dim, x::path))
}

/*
for (dim <- 1 to 8) {
  val t = first_tour(dim, List((0, 0)))
  println(s"${dim} x ${dim} " + (if (t == None) "" else { print_board(dim, t.get) ; "" }))
}
*/

def add_pair_urban(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal_urban(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves_urban(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair_urban(x))

def legal_moves_urban(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves_urban(x).filter(is_legal_urban(dim, path))

def correct_urban(dim: Int)(p: Path): Boolean = p match {
  case Nil => true
  case x::Nil => true
  case x::y::p => 
    if (legal_moves_urban(dim, p, y).contains(x)) correct_urban(dim)(y::p) else false
}



 
val ts1 = first_tour(8, List((0, 0))).get
  assert(correct_urban(8)(ts1) == true)

val ts2 = first_tour(4, List((0, 0)))
assert(ts2 == None)  

print_board(8, first_tour(8, List((0, 0))).get)


