// Shunting Yard Algorithm 
// including Associativity for Operators 
// =====================================

object CW8b { 

// type of tokens
type Toks = List[String]

// helper function for splitting strings into tokens
def split(s: String) : Toks = s.split(" ").toList

// left- and right-associativity
abstract class Assoc
case object LA extends Assoc
case object RA extends Assoc

// power is right-associative,
// everything else is left-associative
def assoc(s: String) : Assoc = s match {
  case "^" => RA
  case _ => LA
}

// the precedences of the operators
val precs = Map("+" -> 1,
  		 "-" -> 1,
		 "*" -> 2,
		 "/" -> 2,
                 "^" -> 4)

// the operations in the basic version of the algorithm
val ops = List("+", "-", "*", "/", "^")

// (8) Implement the extended version of the shunting yard algorithm.
// This version should properly account for the fact that the power 
// operation is right-associative. Apart from the extension to include
// the power operation, you can make the same assumptions as in 
// basic version.

def is_op(op: String) : Boolean = ops.contains(op)

def prec(op1: String, op2: String) : Boolean = assoc(op1) match {
  case LA => precs(op1) <= precs(op2)
  case RA => precs(op1) < precs(op2)
}

def syard(toks: Toks, st: Toks = Nil, out: Toks = Nil) : Toks = (toks, st, out) match {
  case (Nil, _, _) => out.reverse ::: st
  case (num::in, st, out) if (num.forall(_.isDigit)) => 
    syard(in, st, num :: out)
  case (op1::in, op2::st, out) if (is_op(op1) && is_op(op2) && prec(op1, op2)) =>
    syard(op1::in, st, op2 :: out) 
  case (op1::in, st, out) if (is_op(op1)) => syard(in, op1::st, out)
  case ("("::in, st, out) => syard(in, "("::st, out)
  case (")"::in, op2::st, out) =>
    if (op2 == "(") syard(in, st, out) else syard(")"::in, st, op2 :: out)
  case (in, st, out) => {
    println(s"in: ${in}   st: ${st}   out: ${out.reverse}")
    Nil
  }  
} 

def op_comp(s: String, n1: Long, n2: Long) = s match {
  case "+" => n2 + n1
  case "-" => n2 - n1
  case "*" => n2 * n1
  case "/" => n2 / n1
  case "^" => Math.pow(n2, n1).toLong
} 

def compute(toks: Toks, st: List[Long] = Nil) : Long = (toks, st) match {
  case (Nil, st) => st.head
  case (op::in, n1::n2::st) if (is_op(op)) => compute(in, op_comp(op, n1, n2)::st)
  case (num::in, st) => compute(in, num.toInt::st)  
}




//compute(syard(split("3 + 4 * ( 2 - 1 )")))   // 7
//compute(syard(split("10 + 12 * 33")))       // 406
//compute(syard(split("( 5 + 7 ) * 2")))      // 24
//compute(syard(split("5 + 7 / 2")))          // 8
//compute(syard(split("5 * 7 / 2")))          // 17
//compute(syard(split("9 + 24 / ( 7 - 3 )"))) // 15

//compute(syard(split("4 ^ 3 ^ 2")))      // 262144
//compute(syard(split("4 ^ ( 3 ^ 2 )")))  // 262144
//compute(syard(split("( 4 ^ 3 ) ^ 2")))  // 4096
//compute(syard(split("( 3 + 1 ) ^ 2 ^ 3")))   // 65536

//syard(split("3 + 4 * 8 / ( 5 - 1 ) ^ 2 ^ 3"))  // 3 4 8 * 5 1 - 2 3 ^ ^ / +
//compute(syard(split("3 + 4 * 8 / ( 5 - 1 ) ^ 2 ^ 3"))) // 3

//compute(syard(split("( 3 + 1 ) ^ 2 ^ 3")))   // 65536



}
