object CW6a {

//(1) Complete the collatz function below. It should
//    recursively calculate the number of steps needed 
//    until the collatz series reaches the number 1.
//    If needed, you can use an auxiliary function that
//    performs the recursion. The function should expect
//    arguments in the range of 1 to 1 Million.
def stepsCounter(n: Long, s: Long) : Long = n match{
    case 1 => s
    case n if(n%2==0) => stepsCounter(n/2,s+1)
    case _ => stepsCounter(3*n+1, s+1)
}

def collatz(n: Long) : Long = n match {
    case n if(n>0) => stepsCounter(n,0)
    case n if(n<=0) => stepsCounter(1,0)
}



//(2) Complete the collatz_max function below. It should
//    calculate how many steps are needed for each number 
//    from 1 up to a bound and then calculate the maximum number of
//    steps and the corresponding number that needs that many 
//    steps. Again, you should expect bounds in the range of 1
//    up to 1 Million. The first component of the pair is
//    the maximum number of steps and the second is the 
//    corresponding number.

def collatz_max(bnd: Long) : (Long, Long) =  {
    val allCollatz = for(i<-1L until bnd) yield collatz(i)
    val pair = (allCollatz.max, (allCollatz.indexOf(allCollatz.max) +1).toLong)
    pair
}

}
