#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo `date` >> $out
echo >> $out
echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for the Preliminary Part of Assignment 6.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

echo "The feedback for your submission for collatz.scala" >> $out
echo "" >> $out

# marks for CW6 basic part 
marks=$(( 0 ))

# compilation tests

function scala_compile {
  (ulimit -t 60; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
  (ulimit -t 60; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo "collatz.scala does not contain vars, return etc?" | tee -a $out

if (scala_vars collatz.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi

### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo "collatz.scala runs?" | tee -a $out

  if (scala_compile collatz.scala)
  then
    echo "  --> success" | tee -a $out
    tsts=$(( 0 ))
  else
    echo "  --> scala collatz.scala did not run successfully" | tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

echo >> $out

### collatz tests

if [ $tsts -eq 0 ]
then
  echo "collatz.scala tests:" | tee -a $out
  echo "  collatz(1) == 0" | tee -a $out
  echo "  collatz(6) == 8" | tee -a $out
  echo "  collatz(9) == 19" | tee -a $out
  echo "  collatz(9000) == 47" | tee -a $out

  if (scala_assert "collatz.scala" "collatz_test1.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 2 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi

### collatz-max tests

if [ $tsts -eq 0 ]
then
  echo "  collatz_max(10) == (19, 9)" | tee -a $out
  echo "  collatz_max(100) == (118, 97)" | tee -a $out
  echo "  collatz_max(1000) == (178, 871)" | tee -a $out
  echo "  collatz_max(10000) == (261, 6171)" | tee -a $out
  echo "  collatz_max(100000) == (350, 77031)" | tee -a $out
  echo "  collatz_max(1000000) == (524, 837799)" | tee -a $out
  #  echo "  collatz_max(2) == (1, 2) || collatz_max(2) == (0, 1)" | tee -a $out
  echo "  collatz_max(2) == (1, 2)" | tee -a $out
  echo "  collatz_max(77000) == (339, 52527)" | tee -a $out

  if (scala_assert "collatz.scala" "collatz_test2.scala") 
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
    echo "  --> one of the tests failed" | tee -a $out
  fi
fi



## final marks
echo >> $out
echo "Overall mark for the Basic Part" | tee -a $out
echo " $marks" | tee -a $out


