import CW8b._


//type Pos = (Int, Int)
//type Path = List[Pos]

def add_pair_urban(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal_urban(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves_urban(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair_urban(x))

def legal_moves_urban(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves_urban(x).filter(is_legal_urban(dim, path))

def correct_urban(dim: Int)(p: Path): Boolean = p match {
  case Nil => true
  case x::Nil => true
  case x::y::p => 
    if (legal_moves_urban(dim, p, y).contains(x)) correct_urban(dim)(y::p) else false
}


val ts8 = first_tour_heuristic(8, List((0,0))).get
assert(correct_urban(8)(ts8) == true)

val ts30 = first_tour_heuristic(30, List((0,0))).get
assert(correct_urban(30)(ts30) == true)

