// Part 1 about Roman Numerals
//=============================

abstract class RomanDigit 
case object I extends RomanDigit 
case object V extends RomanDigit 
case object X extends RomanDigit 
case object L extends RomanDigit 
case object C extends RomanDigit 
case object D extends RomanDigit 
case object M extends RomanDigit 

type RomanNumeral = List[RomanDigit] 


// (1) First write a polymorphic function that recursively
// transforms a list of options into an option of a list.
// As soon as a None is inside the list, the result is None. 
// Otherwise produce a list of all Some's appended.

def optionlist[A](xs: List[Option[A]]): Option[List[A]] = xs match {
  case Nil => Some(Nil)
  case x::xs => (x, optionlist(xs)) match {
    case (None, _) => None
    case (_, None) => None
    case (Some(y), Some(ys)) => Some(y::ys)  
  }
}

optionlist(List(Some(1), Some(2), Some(3)))
optionlist(List(Some(1), None, Some(3)))
optionlist(List())

// (2) Write a function first a function that converts a character
// into a roman digit (if possible). Then convert a string into
// a roman numeral (if possible). If this is not possible, the functions
// should return None.

def Char2RomanDigit(c: Char): Option[RomanDigit] = c match {
  case 'I' => Some(I)
  case 'V' => Some(V)
  case 'X' => Some(X)
  case 'L' => Some(L)
  case 'C' => Some(C)
  case 'D' => Some(D)
  case 'M' => Some(M)
  case _ => None
}

def String2RomanNumeral(s: String) : Option[RomanNumeral] = 
  optionlist(s.toList.map(Char2RomanDigit))

// some test cases
String2RomanNumeral("IIII")
String2RomanNumeral("IV")
String2RomanNumeral("VI")
String2RomanNumeral("IX")
String2RomanNumeral("MCMLXXIX")
String2RomanNumeral("MCMXLIV") 
String2RomanNumeral("M C M X L I V")  // None


// (3) Write a recursive function RomanNumral2Int that converts a
// RomanNumeral into an integer.

def RomanNumeral2Int(rs: RomanNumeral): Int = rs match { 
  case Nil => 0
  case M::r    => 1000 + RomanNumeral2Int(r)  
  case C::M::r => 900 + RomanNumeral2Int(r)
  case D::r    => 500 + RomanNumeral2Int(r)
  case C::D::r => 400 + RomanNumeral2Int(r)
  case C::r    => 100 + RomanNumeral2Int(r)
  case X::C::r => 90 + RomanNumeral2Int(r)
  case L::r    => 50 + RomanNumeral2Int(r)
  case X::L::r => 40 + RomanNumeral2Int(r)
  case X::r    => 10 + RomanNumeral2Int(r)
  case I::X::r => 9 + RomanNumeral2Int(r)
  case V::r    => 5 + RomanNumeral2Int(r)
  case I::V::r => 4 + RomanNumeral2Int(r)
  case I::r    => 1 + RomanNumeral2Int(r)
}

// some test cases
RomanNumeral2Int(List(I,I,I,I))         // 4
RomanNumeral2Int(List(I,V))             // 4
RomanNumeral2Int(List(V,I))             // 6
RomanNumeral2Int(List(I,X))             // 9
RomanNumeral2Int(List(M,C,M,L,X,X,I,X)) // 1979
RomanNumeral2Int(List(M,C,M,X,L,I,V))   // 1944


// (4) Write a function that converts a string (containing
// a roman numeral) into an integer (if possible). If not
// this is not possible, the functions should return None.

def String2Int(s: String): Option[Int] = 
  String2RomanNumeral(s).map(RomanNumeral2Int(_))


String2Int("IIII")      // 4 invalid 
String2Int("IV")        // 4
String2Int("VI")        // 6
String2Int("IX")        // 9
String2Int("MCMLXXIX")  // 1979
String2Int("MCMXLIV")   // 1944
String2Int("")          // 0
String2Int("MDCLXI")    // 1661
String2Int("MMMCMXCIX") // 3999
String2Int("XLVIII")    // 48
String2Int("MMVIII")    // 2008

String2Int("MMXI")      // 2011 
String2Int("MIM")       // 1999
String2Int("MCMLVI")    // 1956 
String2Int("XXCIII")    // ?? 103 / 83
String2Int("LXXIIX")    // ?? 80 / 78
String2Int("IIIIX")     // ?? 12 invalid  
String2Int("IIXX")      // ?? 20 / 18 invalid

String2Int("III") 	// 3
String2Int("XXX") 	// 30
String2Int("CCC") 	// 300
String2Int("MMM") 	// 3000
String2Int("VII") 	// 7
String2Int("LXVI") 	// 66
String2Int("CL") 	// 150
String2Int("MCC") 	// 1200
String2Int("IV") 	// 4
String2Int("IX") 	// 9
String2Int("XC") 	// 90
String2Int("ICM") 	// ?? 901
String2Int("CIM") 	// ?? 899
String2Int("MDCLXVI")	// 1666

String2Int("VIV")       // 9, but should be written as IX 
String2Int("IVX")       // 14 invalid

// error cases
String2Int("MC?I")
String2Int("abc")

// (5) The file roman.txt contains a list of roman numerals. 
// Read in these numerals, convert them into integers and then 
// add them all up.

import io.Source
import scala.util._

// function for reading files:
// Source.fromFile("file_name")("ISO-8859-9")

def addromanfile(filename: String) = {
  val lines = Source.fromFile(filename)("ISO-8859-9").getLines.toList.map(_.trim)
  lines.map(String2Int(_)).flatten.sum
}


addromanfile("roman.txt")





def runsAllowed(r: RomanDigit) = r match {
  case I | X | C | M => true
  case V | L | D => false
}

def norunsAllowed(r: RomanDigit) = !runsAllowed(r)


def isValidNumeral(digitList: RomanNumeral): Bool = digitList match {

    // empty list is valid
  case Nil => true

    // a following digit that is equal or larger is an error
  case d1::d2::_ if (d1 <= d2)  => false 

    // A single digit is always allowed
  case _::ds => isValidNumeral(ds) 

}
