#!/bin/bash
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission of re.scala." >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
    (sed 's/immutable/ok/g' c$out > cb$out;
     egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' cb$out 2> /dev/null 1> /dev/null)
}



# compilation test

echo -e "re.scala runs?" >> $out

if (scala_compile re.scala)
then
    echo -e "  --> passed" >> $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN RE.SCALA\n" >> $out
    tsts=$(( 1 )) 
fi

# var, return, ListBuffer test
#

if [ $tsts -eq 0 ]
then
    echo -e "re.scala does not contain vars, returns etc?" >> $out

    if (scala_vars re.scala)
    then
	echo -e "  --> FAIL (make triple-sure your program conforms to the required format)" >> $out 
	tsts=$(( 1 ))
    else
	echo -e "  --> passed" >> $out
	tsts=$(( 0 )) 
    fi
fi

### make sure datatypes are not tampered with

if [ $tsts -eq 0 ]
then
    echo -e "re.scala has case classes for ALTs and SEQs?" >> $out

    if (scala_assert "re.scala" "re_test0.scala")
    then
	echo -e "  --> passed" >> $out
	tsts=$(( 0 ))
    else	
	echo -e "  --> FAIL (make sure the case clases are as given in the template)" >> $out 
	tsts=$(( 1 ))
    fi
fi

### re tests

if [ $tsts -eq 0 ]
then
  echo -e " nullable(ZERO) == false" >> $out
  echo -e " nullable(ONE) == true" >> $out
  echo -e " nullable(CHAR('a')) == false" >> $out
  echo -e " nullable(ZERO | ONE) == true" >> $out
  echo -e " nullable(ZERO | CHAR('a')) == false" >> $out
  echo -e " nullable(ONE ~  ONE) == true" >> $out
  echo -e " nullable(ONE ~ CHAR('a')) == false" >> $out
  echo -e " nullable(STAR(ZERO)) == true" >> $out
  echo -e " nullable(ALTs(List(ONE, CHAR('a'), ZERO))) == true" >> $out
  echo -e " nullable(SEQs(List(ONE, ALTs(List(ONE, CHAR('a'), ZERO)), STAR(ZERO)))) == true" >> $out
  
  if (scala_assert "re.scala" "re_test1.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


if [ $tsts -eq 0 ]
then
  echo -e " der('a', ZERO | ONE) == (ZERO | ZERO)" >> $out
  echo -e " der('a', (CHAR('a') | ONE) ~ CHAR('a')) ==" >> $out
  echo -e "                 ALT((ONE | ZERO) ~ CHAR('a'), ONE)" >> $out
  echo -e " der('a', (CHAR('a') | CHAR('a')) ~ CHAR('a')) == (ONE | ONE) ~ CHAR('a')" >> $out
  echo -e " der('a', STAR(CHAR('a'))) == (ONE ~ STAR(CHAR('a')))" >> $out
  echo -e " der('b', STAR(CHAR('a'))) == (ZERO ~ STAR(CHAR('a')))" >> $out
  
  if (scala_assert "re.scala" "re_test2.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


if [ $tsts -eq 0 ]
then
  echo -e " simp(ZERO | ONE) == ONE" >> $out
  echo -e " simp(STAR(ZERO | ONE)) == STAR(ZERO | ONE)" >> $out
  echo -e " simp(ONE ~ (ONE ~ (ONE ~ CHAR('a')))) == CHAR('a')" >> $out
  echo -e " simp(((ONE ~ ONE) ~ ONE) ~ CHAR('a')) == CHAR('a')" >> $out
  echo -e " simp(((ONE | ONE) ~ ONE) ~ CHAR('a')) == CHAR('a')" >> $out
  echo -e " simp(ONE ~ (ONE ~ (ONE ~ ZERO))) == ZERO" >> $out
  echo -e " simp(ALT(ONE ~ (ONE ~ (ONE ~ ZERO)), CHAR('a'))) == CHAR('a')" >> $out
  echo -e " simp(CHAR('a') | CHAR('a')) == CHAR('a')" >> $out
  echo -e " simp(CHAR('a') ~ CHAR('a')) == CHAR('a') ~ CHAR('a')" >> $out
  echo -e " simp(ONE | CHAR('a')) == (ONE | CHAR('a'))" >> $out
  echo -e " simp(ALT((CHAR('a') | ZERO) ~ ONE," >> $out
  echo -e "          ((ONE | CHAR('b')) | CHAR('c')) ~ (CHAR('d') ~ ZERO))) == CHAR('a')" >> $out
  echo -e " simp((ZERO | ((ZERO | ZERO) | (ZERO | ZERO))) ~ ((ONE | ZERO) | ONE ) ~ (CHAR('a'))) == ZERO" >> $out
  echo -e " simp(ALT(ONE | ONE, ONE | ONE)) == ONE" >> $out
  echo -e " simp(ALT(ZERO | CHAR('a'), CHAR('a') | ZERO)) == CHAR('a')" >> $out
  echo -e " simp(ALT(ONE | CHAR('a'), CHAR('a') | ONE)) == ALT(ONE, CHAR('a'))" >> $out
  echo -e " simp(ALTs(Nil)) == ZERO" >> $out
  echo -e " simp(SEQs(CHAR('a'))) == CHAR('a')" >> $out
  if (scala_assert "re.scala" "re_test3.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


if [ $tsts -eq 0 ]
then
    echo -e " denest(List(ONE, ZERO, ALTs(List(ONE, CHAR('a'))))) == List(ONE, ONE, CHAR('a'))" >> $out
    echo -e " denest(List(ONE ~ ONE, ZERO, ZERO | ONE)) == List(ONE ~ ONE, ZERO, ONE)" >> $out
  
  if (scala_assert "re.scala" "re_test4.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi


if [ $tsts -eq 0 ]
then
    echo -e " flts(List(CHAR('a'), ZERO, ONE), Nil) == List(ZERO)" >> $out
    echo -e " flts(List(CHAR('a'), ONE, ONE, CHAR('b')), Nil) == List(CHAR('a'), CHAR('b'))" >> $out
    echo -e " flts(List(ONE ~ CHAR('a'), CHAR('b') ~ ONE), Nil) == List(ONE, CHAR('a'), CHAR('b'), ONE)" >> $out
  
  if (scala_assert "re.scala" "re_test5.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi


if [ $tsts -eq 0 ]
then
    echo -e " SEQs_smart(Nil) == ONE" >> $out
    echo -e " SEQs_smart(List(ZERO)) == ZERO" >> $out
    echo -e " SEQs_smart(List(CHAR('a'))) == CHAR('a')" >> $out
    echo -e " SEQs_smart(List(ONE ~ ONE)) == ONE ~ ONE" >> $out
    echo -e " SEQs_smart(List(ONE, ONE)) == SEQs(List(ONE, ONE))" >> $out
    echo -e " ALTs_smart(Nil) == ZERO" >> $out
    echo -e " ALTs_smart(List(ONE ~ ONE)) == ONE ~ ONE)" >> $out
    echo -e " ALTs_smart(List(ZERO, ZERO)) == ALTs(List(ZERO, ZERO))" >> $out
  
  if (scala_assert "re.scala" "re_test6.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi


if [ $tsts -eq 0 ]
then
  echo -e " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" >> $out
  echo -e " ders(\"aaaaa\".toList, EVIL) == SEQs(List(STAR(CHAR('a')), STAR(STAR(CHAR('a'))), CHAR('b')))" >> $out
  echo -e " ders(List('b'), EVIL) == ONE" >> $out
  echo -e " ders(\"bb\".toList, EVIL) == ZERO" >> $out
  echo -e " matcher(EVIL, \"a\" * 5 ++ \"b\") == true" >> $out
  echo -e " matcher(EVIL, \"b\") == true" >> $out
  echo -e " matcher(EVIL, \"bb\") == false" >> $out
  echo -e " matcher(\"abc\", \"abc\") == true" >> $out
  echo -e " matcher((\"ab\" | \"a\") ~ (ONE | \"bc\"), \"abc\") == true" >> $out
  echo -e " matcher(ONE, \"\") == true" >> $out
  echo -e " matcher(ZERO, \"\") == false" >> $out
  echo -e " matcher(ONE | CHAR('a'), \"\") == true" >> $out
  echo -e " matcher(ONE | CHAR('a'), \"a\") == true" >> $out
  
  if (scala_assert "re.scala" "re_test7.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi


if [ $tsts -eq 0 ]
then
  echo -e " val EVIL = SEQ(STAR(STAR(CHAR('a'))), CHAR('b'))" >> $out  
  echo -e " size(der('a', der('a', EVIL))) == 36" >> $out
  echo -e " size(der('a', der('a', der('a', EVIL)))) == 83" >> $out
  echo -e " size(ders(\"aaaaaa\".toList, EVIL)) == 7" >> $out
  echo -e " size(ders((\"a\" * 50).toList, EVIL)) == 7" >> $out
  
  if (scala_assert "re.scala" "re_test8.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi


