#!/bin/bash
set -euo pipefail


out=${1:-output}

echo "" > $out

echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 6 Part 3.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for CW7 part 3
marks=$(( 0 ))

# compilation tests

function scala_compile {
    (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 360; JAVA_OPTS="-Xmx4g" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}


# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}



# var, .par return, ListBuffer test
#
echo "drumb.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars drumb.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then 
  echo "drumb.scala runs?" | tee -a $out

  if (scala_compile drumb.scala)
  then
    echo "  --> success" | tee -a $out
    tsts=$(( 0 ))
  else
    echo "  --> scala drumb.scala did not run successfully" | tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi



### get prices tests

if [ $tsts -eq 0 ]
then
  echo " get_prices(List(\"BIDU\"), 2004 to 2008) ==" | tee -a $out
  echo "       List(List(None), List(None), List(Some(6.35)), " | tee -a $out
  echo "            List(Some(12.241)), List(Some(38.188)))" | tee -a $out
  echo " " | tee -a $out  
  echo "  get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012) ==" | tee -a $out
  echo "       List(List(Some(311.349976), Some(27.505054))," | tee -a $out
  echo "            List(Some(300.222351), Some(42.357094))," | tee -a $out
  echo "            List(Some(330.555054), Some(52.852215)))" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test1.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 2 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi

### get_deltas_test

if [ $tsts -eq 0 ]
then
  echo " val prices1 = get_prices(List(\"BIDU\"), 2004 to 2008)" | tee -a $out
  echo " val prices2 = get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)" | tee -a $out
  echo " " | tee -a $out  
  echo " get_deltas(prices1) == List(List(None), List(None), " | tee -a $out
  echo "                             List(Some(0.9277165354330709)), " | tee -a $out
  echo "                             List(Some(2.119679764725104)))" | tee -a $out
  echo " " | tee -a $out  
  echo " get_deltas(prices2) == List(List(Some(-0.03573992567129673), Some(0.5399749442411563)), " | tee -a $out
  echo "                             List(Some(0.10103412653643493), Some(0.2477771728154912)))" | tee -a $out
  
  if (scala_assert "drumb.scala" "drumb_test2.scala") 
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi


### yield_tests, investment_test

if [ $tsts -eq 0 ]
then
  echo " val prices1 = get_prices(List(\"BIDU\"), 2004 to 2008)" | tee -a $out
  echo " val prices2 = get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)" | tee -a $out
  echo " val prices3 = get_prices(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2010 to 2012)" | tee -a $out 
  echo " val deltas1 = get_deltas(prices1)" | tee -a $out
  echo " val deltas2 = get_deltas(prices2)" | tee -a $out
  echo " val deltas3 = get_deltas(prices3)" | tee -a $out
  echo "" | tee -a $out
  echo " yearly_yield(deltas1, 100, 0) == 100" | tee -a $out
  echo " yearly_yield(deltas1, 100, 2) == 192" | tee -a $out
  echo " yearly_yield(deltas2, 100, 0) == 125" | tee -a $out
  echo " yearly_yield(deltas3, 100, 0) == 164" | tee -a $out
  echo " yearly_yield(deltas3, 100, 1) == 119" | tee -a $out
  echo "" | tee -a $out
  echo " val inv1 = investment(List(\"IBM\", \"BIDU\"), 2004 to 2008, 100)" | tee -a $out
  echo " val inv2 = investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2010 to 2012, 100)" | tee -a $out
  echo "" | tee -a $out
  echo " inv1 >= 295 && inv1 <= 301" | tee -a $out
  echo " inv2 >= 194 && inv2 <= 198" | tee -a $out
  
  if (scala_assert "drumb.scala" "drumb_test3.scala") 
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi



## final marks
echo "Overall mark for CW 6, Part 3" | tee -a $out
echo "$marks" | tee -a $out
