
import io.Source
import scala.util._

import M2._

def urban_get_csv_file(name: String) : List[String] = {
  val csv = Source.fromFile(name)
  csv.mkString.split("\n").toList.drop(1)
}

val urban_ratings = urban_get_csv_file("ratings.csv")
val urban_movies = urban_get_csv_file("movies.csv")

val urban_res1 = process_ratings(urban_ratings)
val urban_rat_elems = List(("1","1"), ("1","3"), ("1","6"), ("1","47"))

assert(urban_res1.length == 48580)
assert(urban_rat_elems.forall(urban_res1.contains(_)))

assert(process_movies(urban_movies).length == 9742)


