#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

# compilation tests

function scala_compile {
  (ulimit -t 60; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> ptmp 1> ptmp)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|mutable|new Array' ptmp 2> /dev/null 1> /dev/null)
}


### compilation test

echo "collatz.scala runs?" | tee -a $out

if (scala_compile collatz.scala)
then
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 ))
else
  echo "  --> scala collatz.scala did not run successfully" | tee -a $out
  tsts0=$(( 1 )) 
fi

# var, .par return, ListBuffer test
#

if  [ $tsts0 -eq 0 ]
then
  echo "collatz.scala does not contain var, return etc?" | tee -a $out

  if (scala_vars tmp)
  then
    echo "  --> test failed" | tee -a $out
    tsts=$(( 1 ))
  else
    echo "  --> success" | tee -a $out
    tsts=$(( 0 )) 
  fi
fi  

###rm tmp


