
import scala.concurrent._
import scala.concurrent.duration._
import ExecutionContext.Implicits.global
import scala.language.postfixOps 

type Pos = (Int, Int)    // a position on a chessboard 
type Path = List[Pos]    // a path...a list of positions

def count_all_tours_urban(dim: Int) = {
  for (i <- (0 until dim).toList; 
       j <- (0 until dim).toList) yield CW7a.count_tours(dim, List((i, j)))
}

def add_pair_urban(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal_urban(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves_urban(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair_urban(x))

def legal_moves_urban(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves_urban(x).filter(is_legal_urban(dim, path))

def correct_urban(dim: Int)(p: Path): Boolean = p match {
  case Nil => true
  case x::Nil => true
  case x::y::p => if (legal_moves_urban(dim, p, y).contains(x)) correct_urban(dim)(y::p) else false
}


lazy val f = Future {
  assert(count_all_tours_urban(1) == List(1))
  assert(count_all_tours_urban(2) == List(0, 0, 0, 0))
  assert(count_all_tours_urban(3) == List(0, 0, 0, 0, 0, 0, 0, 0, 0))
  assert(count_all_tours_urban(4) == List(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0))
  assert(count_all_tours_urban(5) == List(304, 0, 56, 0, 304, 0, 56, 0, 56, 0, 56, 0, 64, 0, 56, 0, 56, 0, 56, 0, 304, 0, 56, 0, 304))

  val ts = CW7a.enum_tours(5, List((0, 2)))
  assert(ts.map(correct_urban(5)).forall(_ == true) == true)
  assert(ts.length == 56)  
}

Await.result(f, 360 second)
