// Shunting Yard Algorithm
// Edsger Dijkstra


type Toks = List[String]

def split(s: String) = s.split(" ").toList


abstract class Assoc
case object RA extends Assoc
case object LA extends Assoc

def assoc(s: String) : Assoc = s match {
  case "^" => RA
  case _ => LA
}


val precs = Map("+" -> 1,
  		 "-" -> 1,
		 "*" -> 2,
		 "/" -> 2,
                 "^" -> 4)

val ops = List("+", "-", "*", "/", "^")

def is_op(op: String) : Boolean = ops.contains(op)

def prec(op1: String, op2: String) : Boolean = assoc(op1) match {
  case LA => precs(op1) <= precs(op2)
  case RA => precs(op1) < precs(op2)
}

def syard(toks: Toks, st: Toks = Nil, rout: Toks = Nil) : Toks = (toks, st, rout) match {
  case (Nil, _, _) => rout.reverse ::: st
  case (num::in, st, rout) if (num.forall(_.isDigit)) => 
    syard(in, st, num :: rout)
  case (op1::in, op2::st, rout)  if (is_op(op1) && is_op(op2) && prec(op1, op2)) =>
    syard(op1::in, st, op2 :: rout) 
  case (op1::in, st, rout) if (is_op(op1)) => syard(in, op1::st, rout)
  case ("("::in, st, rout) => syard(in, "("::st, rout)
  case (")"::in, op2::st, rout) =>
    if (op2 == "(") syard(in, st, rout) else syard(")"::in, st, op2 :: rout)
  case (in, st, rout) => {
    println(s"in: ${in}   st: ${st}   rout: ${rout.reverse}")
    Nil
  }  
} 

def op_comp(s: String, n1: Long, n2: Long) = s match {
  case "+" => n2 + n1
  case "-" => n2 - n1
  case "*" => n2 * n1
  case "/" => n2 / n1
  case "^" => Math.pow(n2, n1).toLong
} 

def compute(toks: Toks, st: List[Long] = Nil) : Long = (toks, st) match {
  case (Nil, st) => st.head
  case (op::in, n1::n2::st) if (is_op(op)) => compute(in, op_comp(op, n1, n2)::st)
  case (num::in, st) => compute(in, num.toInt::st)  
}




compute(syard(split("3 + 4 * ( 2 - 1 )")))   // 7
compute(syard(split("10 + 12 * 33")))       // 406
compute(syard(split("( 5 + 7 ) * 2")))      // 24
compute(syard(split("5 + 7 / 2")))          // 8
compute(syard(split("5 * 7 / 2")))          // 17
compute(syard(split("9 + 24 / ( 7 - 3 )"))) // 15

compute(syard(split("4 ^ 3 ^ 2")))      // 262144
compute(syard(split("4 ^ ( 3 ^ 2 )")))  // 262144
compute(syard(split("( 4 ^ 3 ) ^ 2")))  // 4096


syard(split("3 + 4 * 8 / ( 5 - 1 ) ^ 2 ^ 3"))  // 3 4 8 * 5 1 - 2 3 ^ ^ / +
compute(syard(split("3 + 4 * 8 / ( 5 - 1 ) ^ 2 ^ 3")))

compute(syard(split("( 3 + 1 ) ^ 2 ^ 3")))   // 65536


def pow(n1: Long, n2: Long) = Math.pow(n1, n2).toLong 
