#!/bin/bash
set -euo pipefail

out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission of CW 10." >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}



# compilation test
echo -e "bf.scala runs?" >> $out

if (scala_compile bf.scala)
then
    echo -e "  --> passed" >> $out
    tsts1=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN BF.SCALA\n" >> $out
    tsts1=$(( 1 )) 
fi


# var, return, ListBuffer test
#

if [ $tsts1 -eq 0 ]
then
    echo -e "bf.scala does not contain vars, returns etc?" >> $out

    if (scala_vars bf.scala)
    then
	echo -e "   --> FAIL (make triple-sure your program conforms to the required format)" >> $out  
	tsts1=$(( 1 ))
    else
	echo -e "  --> passed" >> $out
	tsts1=$(( 0 )) 
    fi
fi



### bf tests

if [ $tsts1 -eq 0 ]
then
  echo -e " load_bff(\"benchmark.bf\").length == 188" >> $out
  echo -e " load_bff(\"foobar.bf\") == \"\"" >> $out  
  
  if (scala_assert "bf.scala" "bf_test1.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi

if [ $tsts1 -eq 0 ]
then
  echo -e " sread(Map(), 2) == 0" >> $out
  echo -e " sread(Map(2 -> 1), 2) == 1" >> $out  
  echo -e " write(Map(), 1, 2) == Map(1 -> 2)" >> $out
  echo -e " write(Map(1 -> 0), 1, 2) == Map(1 -> 2)" >> $out
  
  if (scala_assert "bf.scala" "bf_test2.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi



if [ $tsts1 -eq 0 ]
then
    echo -e " jumpRight(\"[xxxxxx]xxx\", 1, 0) == 8" >> $out
    echo -e " jumpRight(\"[xx[x]x]xxx\", 1, 0) == 8" >> $out
    echo -e " jumpRight(\"[xx[x]x]xxx\", 1, 0) == 8" >> $out
    echo -e " jumpRight(\"[xx[xxx]xxx\", 1, 0) == 11" >> $out
    echo -e " jumpRight(\"[x[][]x]xxx\", 1, 0) == 8" >> $out
    echo -e " jumpLeft(\"[xxxxxx]xxx\", 6, 0) == 1" >> $out
    echo -e " jumpLeft(\"[xxxxxx]xxx\", 7, 0) == -1" >> $out
    echo -e " jumpLeft(\"[x[][]x]xxx\", 6, 0) == 1" >> $out
  
  if (scala_assert "bf.scala" "bf_test3.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out   
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo -e " run(\"[-]\", Map(0 -> 100)) == Map(0 -> 0)" >> $out
  echo -e " run(\"[->+<]\", Map(0 -> 10)) == Map(0 -> 0, 1 -> 10)" >> $out
  echo -e " run(\"[>>+>>+<<<<-]\", Map(0 -> 42)) == Map(0 -> 0, 2 -> 42, 4 -> 42)" >> $out
  echo -e " run(\"++++++++++#>+***#\") == Map(0 -> 10, 1 -> 1000))" >> $out
  echo -e " run(\"+++>+@+@+@+@+@\") == Map(0 -> 3, 1 -> 7, 4 -> 3, 5 -> 3, 6 -> 3, 7 -> 3)" >> $out
  
  echo -e " run(\"\"\"+++++[->++++++++++<]>--<+++[->>++++++++++" >> $out
  echo -e "        <<]>>++<<----------[+>.>.<+<]\"\"\") == Map(0 -> 0, 1 -> 58, 2 -> 32)" >> $out

  if (scala_assert "bf.scala" "bf_test4.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out 
  fi
fi




