
// first test 

import CW7b._

def urban_groupById(ratings: List[(String, String)], 
              m: Map[String, List[String]]) : Map[String, List[String]] = ratings match {
  case Nil => m
  case (id, mov) :: rest => {
    val old_ratings = m.getOrElse (id, Nil)
    val new_ratings = m + (id -> (mov :: old_ratings))
    urban_groupById(rest, new_ratings)
  }
}

//def urban_groupById(ratings: List[(String, String)]) = 
//  ratings.groupBy(_._1).view.mapValues(_.map(_._2)).toMap 

def urban_get_csv_file(name: String) : List[String] = {
  import io.Source
  import scala.util._
  val csv = Source.fromFile(name)("ISO-8859-1")
  csv.mkString.split("\n").toList.drop(1)
}

def urban_process_ratings(lines: List[String]) : List[(String, String)] = {
  for (cols <- lines.map(_.split(",").toList); 
       if (cols(2).toInt >= 4)) yield (cols(0), cols(1))  
}


val urban_good_ratings = urban_process_ratings(urban_get_csv_file("ratings.csv"))

val urban_ratings_map = urban_groupById(urban_good_ratings, Map())

assert(suggestions(urban_ratings_map, "912").length  == 4110)
assert(suggestions(urban_ratings_map, "858").length  == 4883)
assert(suggestions(urban_ratings_map, "260").length  == 4970)

