#!/bin/bash

# to make the script fail safely
set -euo pipefail



scalafile=${1:-danube.scala}
out=${2:-output}



echo "" > $out

echo "Below is the feedback for your submission danube.scala" >> $out
echo "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}



### compilation test

echo "danube.scala runs?" >> $out

if (scala_compile $scalafile)
then
    echo "  --> passed" >> $out
    tsts=$(( 0 ))
else
    echo "  --> SCALA DID NOT RUN danube.scala" >> $out
    tsts=$(( 1 )) 
fi

# var, .par return, ListBuffer test
#

if [ $tsts -eq 0 ]
then
    echo "danube.scala does not contain vars, returns etc?" >> $out

    if (scala_vars $scalafile)
    then
	echo "  --> FAIL (make triple-sure your program conforms to the required format)" >> $out
	tsts=$(( 1 ))
    else
	echo "  --> passed" >> $out
	tsts=$(( 0 )) 
    fi
fi


### danube get_cvs_url tests

if [ $tsts -eq 0 ]
then
  echo "danube.scala tests:" >> $out
  echo "  val movies_url = \"\"\"https://nms.kcl.ac.uk/christian.urban/movies.csv\"\"\"" >> $out
  echo "  get_csv_url(movies_url).length == 9742" >> $out

  if (scala_assert $scalafile "danube_test1.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### danube processing tests

if [ $tsts -eq 0 ]
then
  echo "  val good_ratings = process_ratings(ratings)" >> $out
  echo "  val movie_names = process_movies(movies)" >> $out  
  echo "  " >> $out
  echo "  good_ratings.length == 48580 " >> $out
  echo "  movie_names.length == 9742 " >> $out
  echo "  " >> $out
  echo "  val r_elems = List((\"1\",\"1\"), (\"1\",\"3\"), (\"1\",\"6\"), (\"1\",\"47\")) " >> $out
  echo "  r_elems.forall(good_ratings.contains(_)) == true" >> $out

  if (scala_assert $scalafile "danube_test2.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### danube groupById test

if [ $tsts -eq 0 ]
then
  echo -e  "  val ls1 = List((\"1\", \"a\"), (\"2\", \"a\"), (\"1\", \"c\"), (\"2\", \"a\"), (\"1\", \"c\"))" >> $out
  echo -e  "  val ls2 = List((\"1\", \"a\"), (\"1\", \"b\"), (\"2\", \"x\"), (\"3\", \"a\"), (\"2\", \"y\"), (\"3\", \"c\"))" >> $out
  echo -e  "  groupById(ls1, Map()) == Map(1 -> List(c, c, a), 2 -> List(a, a))" >> $out
  echo -e  "  groupById(ls2, Map()) == Map(1 -> List(b, a), 2 -> List(x, y), 3 -> List(c, a))" >> $out
  echo -e  "      where the order in the lists is unimportant" >> $out
  echo -e  "  val ls3 = (1 to 1000).map(_.toString).toList" >> $out
  echo -e  "  val ls4 = ls3 zip ls3.tail" >> $out
  echo -e  "  val ls5 = ls4 ::: ls4.reverse" >> $out
  echo -e  "  groupById(ls5, Map()) == Map(1 -> List(2,2), 2 -> List(3,3), ....)" >> $out

  if (scala_assert $scalafile "danube_test3.scala")
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### danube favourites tests

if [ $tsts -eq 0 ]
then
  echo -e  "  val good_ratings = process_ratings(ratings)" >> $out
  echo -e  "  val ratings_map = groupById(good_ratings, Map())" >> $out
  echo -e  "  favourites(ratings_map, \"912\").length  == 80 " >> $out
  echo -e  "  favourites(ratings_map, \"858\").length  == 158 " >> $out
  echo -e  "  favourites(ratings_map, \"260\").length  == 201 " >> $out  

  if (scala_assert $scalafile "danube_test4.scala") 
  then
    echo -e  "  --> success" >> $out
  else
    echo -e  "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### danube suggestions tests

if [ $tsts -eq 0 ]
then
  echo -e  "  val good_ratings = process_ratings(ratings)" >> $out
  echo -e  "  val ratings_map = groupById(good_ratings, Map())" >> $out
  echo -e  "  suggestions(ratings_map, \"912\").length  == 4110 " >> $out
  echo -e  "  suggestions(ratings_map, \"858\").length  == 4883 " >> $out
  echo -e  "  suggestions(ratings_map, \"260\").length  == 4970 " >> $out  

  if (scala_assert $scalafile "danube_test5.scala") 
  then
    echo -e  "  --> success" >> $out
  else
    echo -e  "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### danube recommendation tests

if [ $tsts -eq 0 ]
then
  echo -e  "  recommendations(ratings_map, movies_map, \"1\").length  == 2 " >> $out
  echo -e  "  recommendations(ratings_map, movies_map, \"2\").length  == 2 " >> $out
  echo -e  "  recommendations(ratings_map, movies_map, \"3\").length  == 2 " >> $out
  echo -e  "  recommendations(ratings_map, movies_map, \"4\").length  == 0 " >> $out
  echo -e  "  recommendations(ratings_map, movies_map, \"5\").length  == 2 " >> $out

  if (scala_assert $scalafile "danube_test6.scala") 
  then
    echo -e  "  --> success" >> $out
  else
    echo -e  "  --> ONE OF THE TESTS FAILED\n" >>  $out
  fi
fi



