#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo -e "Below is the feedback for your submission for the advanced part of danube.scala" >> $out
echo -e "" >> $out


# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc -i "$1" "$2" -e "") #2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo "danube.scala does not contain vars, returns etc?" >> $out

if (scala_vars danube.scala)
then
  echo -e "  --> fail (make triple-sure your program conforms to the required format)" >> $out
  tsts0=$(( 0 ))
else
  echo -e "  --> success" >> $out
  tsts0=$(( 0 )) 
fi

### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo "danube.scala runs?" >> $out

  if (scala_compile danube.scala)
  then
    echo -e "  --> success" >> $out
    tsts=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN DANUBE.SCALA\n" >> $out  
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### danube groupById test

if [ $tsts -eq 0 ]
then
  echo "  val ls = List((\"1\", \"a\"), (\"2\", \"a\"), (\"1\", \"c\"), (\"2\", \"a\"), (\"1\", \"c\"))" >> $out
  echo "  groupById(ls, Map()) == Map(1 -> List(c, c, a), 2 -> List(a, a))" >> $out
  echo "      where the order in the lists is unimportant" >> $out

  if (scala_assert "danube.scala" "danube_test3.scala")
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi

### danube processing tests

#if [ $tsts -eq 0 ]
#then
#  echo "  val good_ratings = process_ratings(ratings)" >> $out
#  echo "  val movie_names = process_movies(movies)" >> $out  
#  echo "  " >> $out
#  echo "  good_ratings.length == 48580 " >> $out
#  echo "  movie_names.length == 9742 " >> $out
#
#  if (scala_assert "danube.scala" "danube_test2.scala") 
#  then
#    echo "  --> success" >> $out
#  else
#    echo "  --> one of the tests failed" >> $out
#  fi
#fi

echo -e "\nFor other testcases please look at the template file." >> $out
