#!/bin/bash
set -euo pipefail


out=${1:-output}

# read marks for CW6 part 1
marks=$(( `tail -1 $out` ))

echo $marks

echo "" >> $out
echo "Below is the feedback for your submission drumb.scala" >> $out
echo "" >> $out


# compilation tests

function scala_compile {
    (ulimit -t 60; JAVA_OPTS="-Xmx1g" scala -nc  "$1" 2> /dev/null 1> /dev/null)
}

# functional tests

function scala_assert {
    (ulimit -t 60; JAVA_OPTS="-Xmx4g" scala -nc -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}


# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}



# var, .par return, ListBuffer test
#
echo "drumb.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars drumb.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then 
  echo "drumb.scala runs?" | tee -a $out

  if (scala_compile drumb.scala)
  then
    echo "  --> success" | tee -a $out
    tsts=$(( 0 ))
  else
    echo "  --> scala drumb.scala did not run successfully" | tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### get january tests

if [ $tsts -eq 0 ]
then
  echo "  get_january_data(\"GOOG\", 1980) == List()" | tee -a $out
  echo "  get_january_data(\"GOOG\", 2010).head == \"2010-01-04,311.349976\"" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test1.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi

### get first price tests

if [ $tsts -eq 0 ]
then
  echo "  get_first_price(\"GOOG\", 1980) == None" | tee -a $out
  echo "  get_first_price(\"GOOG\", 2010) == Some(311.349976)" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test2.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi

### get prices tests

if [ $tsts -eq 0 ]
then
  echo "  get_prices(List(\"BIDU\"), 2004 to 2008) ==" | tee -a $out
  echo "       List(List(None), List(None), List(Some(6.35)), " | tee -a $out
  echo "            List(Some(12.241)), List(Some(38.188)))" | tee -a $out
  echo " " | tee -a $out  
  echo "  get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012) ==" | tee -a $out
  echo "       List(List(Some(311.349976), Some(20.544939))," | tee -a $out
  echo "            List(Some(300.222351), Some(31.638695))," | tee -a $out
  echo "            List(Some(330.555054), Some(39.478039)))" | tee -a $out

  if (scala_assert "drumb.scala" "drumb_test3.scala")
  then
      echo "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo "  --> test failed" | tee -a $out
  fi
fi

### get_deltas_test

#if [ $tsts -eq 0 ]
#then
#  echo " val prices1 = get_prices(List(\"BIDU\"), 2004 to 2008)" | tee -a $out
#  echo " val prices2 = get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)" | tee -a $out
#  echo " " | tee -a $out  
#  echo " get_deltas(prices1) == List(List(None), List(None), " | tee -a $out
#  echo "                             List(Some(0.9277165354330709)), " | tee -a $out
#  echo "                             List(Some(2.119679764725104)))" | tee -a $out
#  echo " " | tee -a $out  
#  echo " get_deltas(prices2) == List(List(Some(-0.03573992567129673), Some(0.5399749442411563)), " | tee -a $out
#  echo "                             List(Some(0.10103412653643493), Some(0.2477771728154912)))" | tee -a $out
#  
#  if (scala_assert "drumb.scala" "drumb_test2.scala") 
#  then
#      echo "  --> success" | tee -a $out
#      marks=$(( marks + 1 ))
#  else
#      echo "  --> test failed" | tee -a $out
#  fi
#fi


### yield_tests, investment_test

#if [ $tsts -eq 0 ]
#then
#  echo " val prices1 = get_prices(List(\"BIDU\"), 2004 to 2008)" | tee -a $out
#  echo " val prices2 = get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)" | tee -a $out
#  echo " val prices3 = get_prices(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2010 to 2012)" | tee -a $out 
#  echo " val deltas1 = get_deltas(prices1)" | tee -a $out
#  echo " val deltas2 = get_deltas(prices2)" | tee -a $out
#  echo " val deltas3 = get_deltas(prices3)" | tee -a $out
#  echo "" | tee -a $out
#  echo " yearly_yield(deltas1, 100, 0) == 100" | tee -a $out
#  echo " yearly_yield(deltas1, 100, 2) == 192" | tee -a $out
#  echo " yearly_yield(deltas2, 100, 0) == 125" | tee -a $out
#  echo " yearly_yield(deltas3, 100, 0) == 164" | tee -a $out
#  echo " yearly_yield(deltas3, 100, 1) == 119" | tee -a $out
#  echo "" | tee -a $out
#  echo " val inv1 = investment(List(\"IBM\", \"BIDU\"), 2004 to 2008, 100)" | tee -a $out
#  echo " val inv2 = investment(List(\"GOOG\", \"AAPL\", \"BIDU\"), 2010 to 2012, 100)" | tee -a $out
#  echo "" | tee -a $out
#  echo " inv1 >= 295 && inv1 <= 301" | tee -a $out
#  echo " inv2 >= 194 && inv2 <= 198" | tee -a $out
#  
#  if (scala_assert "drumb.scala" "drumb_test3.scala") 
#  then
#      echo "  --> success" | tee -a $out
#      marks=$(( marks + 1 ))
#  else
#      echo "  --> test failed" | tee -a $out
#  fi
#fi



## final marks
echo "Overall mark for CW 6, Part 1 + 2" | tee -a $out
echo "$marks" | tee -a $out
