/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.mutable;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.collection.parallel.BucketCombiner;
import scala.collection.parallel.Task;
import scala.collection.parallel.mutable.ParHashMapCombiner$;
import scala.collection.parallel.mutable.ParHashSet;
import scala.collection.parallel.mutable.ParHashSetCombiner$;
import scala.collection.parallel.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class ParHashSetCombiner<T>
extends BucketCombiner<T, ParHashSet<T>, Object, ParHashSetCombiner<T>>
implements FlatHashTable.HashUtils<T> {
    private final int tableLoadFactor;
    private final int nonmasklen;
    public final int scala$collection$parallel$mutable$ParHashSetCombiner$$seedvalue;

    public static <T> ParHashSetCombiner<T> apply() {
        return ParHashSetCombiner$.MODULE$.apply();
    }

    public static int discriminantbits() {
        return ParHashSetCombiner$.MODULE$.discriminantbits();
    }

    public static int discriminantmask() {
        return ParHashSetCombiner$.MODULE$.discriminantmask();
    }

    public static int nonmasklength() {
        return ParHashSetCombiner$.MODULE$.nonmasklength();
    }

    public static int numblocks() {
        return ParHashSetCombiner$.MODULE$.numblocks();
    }

    public ParHashSetCombiner(int tableLoadFactor) {
        this.tableLoadFactor = tableLoadFactor;
        super(ParHashSetCombiner$.MODULE$.numblocks());
        this.nonmasklen = ParHashSetCombiner$.MODULE$.nonmasklength();
        this.scala$collection$parallel$mutable$ParHashSetCombiner$$seedvalue = 27;
    }

    private int tableLoadFactor() {
        return this.tableLoadFactor;
    }

    public ParHashSetCombiner addOne(T elem) {
        Object entry = this.elemToEntry(elem);
        this.sz_$eq(this.sz() + 1);
        int hc = this.improve(entry.hashCode(), this.scala$collection$parallel$mutable$ParHashSetCombiner$$seedvalue);
        int pos = hc >>> this.nonmasklen;
        if (this.buckets()[pos] == null) {
            this.buckets()[pos] = new UnrolledBuffer(ClassTag$.MODULE$.apply(Object.class));
        }
        this.buckets()[pos].$plus$eq(entry);
        return this;
    }

    public ParHashSet<T> result() {
        FlatHashTable.Contents<T> contents = this.size() >= ParHashSetCombiner$.MODULE$.numblocks() * this.sizeMapBucketSize() ? this.parPopulate() : this.seqPopulate();
        return new ParHashSet<T>(contents);
    }

    private FlatHashTable.Contents<T> parPopulate() {
        AddingFlatHashTable table = new AddingFlatHashTable(this, this.size(), this.tableLoadFactor(), this.scala$collection$parallel$mutable$ParHashSetCombiner$$seedvalue);
        Tuple2<Object, UnrolledBuffer<Object>> tuple2 = this.combinerTaskSupport().executeAndWaitResult(new FillBlocks(this, this.buckets(), table, 0, this.buckets().length));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int inserted = BoxesRunTime.unboxToInt((Object)tuple2._1());
        UnrolledBuffer leftovers = (UnrolledBuffer)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)inserted), (Object)leftovers);
        int inserted2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        UnrolledBuffer leftovers2 = (UnrolledBuffer)tuple22._2();
        IntRef leftinserts = IntRef.create((int)0);
        leftovers2.foreach((Function1)(JProcedure1 & Serializable)entry -> {
            int n;
            leftinserts$1.elem = n = leftinserts$1.elem + table.insertEntry(0, table.tableLength(), entry);
        });
        table.setSize(leftinserts.elem + inserted2);
        return table.hashTableContents();
    }

    private FlatHashTable.Contents<T> seqPopulate() {
        FlatHashTable tbl = new FlatHashTable<T>(this){
            private int _loadFactor;
            private Object[] table;
            private int tableSize;
            private int threshold;
            private int[] sizemap;
            private int seedvalue;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                FlatHashTable.$init$(this);
                this.sizeMapInit(this.table().length);
                this.seedvalue_$eq($outer.scala$collection$parallel$mutable$ParHashSetCombiner$$seedvalue);
                Object object = Predef$.MODULE$.refArrayOps((Object[])$outer.buckets());
                ArrayOps$.MODULE$.withFilter$extension(object, ParHashSetCombiner::scala$collection$parallel$mutable$ParHashSetCombiner$$anon$1$$_$$lessinit$greater$$anonfun$1).foreach((Function1)(JProcedure1 & Serializable)buffer -> buffer.foreach((Function1 & Serializable)entry -> this.addEntry(entry)));
            }

            public int _loadFactor() {
                return this._loadFactor;
            }

            public Object[] table() {
                return this.table;
            }

            public int tableSize() {
                return this.tableSize;
            }

            public int threshold() {
                return this.threshold;
            }

            public int[] sizemap() {
                return this.sizemap;
            }

            public int seedvalue() {
                return this.seedvalue;
            }

            public void _loadFactor_$eq(int x$1) {
                this._loadFactor = x$1;
            }

            public void table_$eq(Object[] x$1) {
                this.table = x$1;
            }

            public void tableSize_$eq(int x$1) {
                this.tableSize = x$1;
            }

            public void threshold_$eq(int x$1) {
                this.threshold = x$1;
            }

            public void sizemap_$eq(int[] x$1) {
                this.sizemap = x$1;
            }

            public void seedvalue_$eq(int x$1) {
                this.seedvalue = x$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scala$collection$parallel$mutable$ParHashSetCombiner$$anon$1$$_$$lessinit$greater$$anonfun$1(scala.collection.mutable.UnrolledBuffer ), $init$$$anonfun$1(scala.collection.mutable.UnrolledBuffer ), $init$$$anonfun$2$$anonfun$1(java.lang.Object )}, serializedLambda);
            }
        };
        return tbl.hashTableContents();
    }

    public static final /* synthetic */ boolean scala$collection$parallel$mutable$ParHashSetCombiner$$anon$1$$_$$lessinit$greater$$anonfun$1(UnrolledBuffer buffer) {
        return buffer != null;
    }

    public class AddingFlatHashTable
    implements FlatHashTable<T> {
        private int _loadFactor;
        private Object[] table;
        private int tableSize;
        private int threshold;
        private int[] sizemap;
        private int seedvalue;
        private final ParHashSetCombiner<T> $outer;

        public AddingFlatHashTable(ParHashSetCombiner $outer, int numelems, int lf, int inseedvalue) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            FlatHashTable.$init$(this);
            this._loadFactor_$eq(lf);
            this.table_$eq(new Object[this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(numelems, this._loadFactor()))]);
            this.tableSize_$eq(0);
            this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
            this.seedvalue_$eq(inseedvalue);
            this.sizeMapInit(this.table().length);
        }

        @Override
        public int _loadFactor() {
            return this._loadFactor;
        }

        @Override
        public Object[] table() {
            return this.table;
        }

        @Override
        public int tableSize() {
            return this.tableSize;
        }

        @Override
        public int threshold() {
            return this.threshold;
        }

        @Override
        public int[] sizemap() {
            return this.sizemap;
        }

        @Override
        public int seedvalue() {
            return this.seedvalue;
        }

        @Override
        public void _loadFactor_$eq(int x$1) {
            this._loadFactor = x$1;
        }

        @Override
        public void table_$eq(Object[] x$1) {
            this.table = x$1;
        }

        @Override
        public void tableSize_$eq(int x$1) {
            this.tableSize = x$1;
        }

        @Override
        public void threshold_$eq(int x$1) {
            this.threshold = x$1;
        }

        @Override
        public void sizemap_$eq(int[] x$1) {
            this.sizemap = x$1;
        }

        @Override
        public void seedvalue_$eq(int x$1) {
            this.seedvalue = x$1;
        }

        public String toString() {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("AFHT(%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.table().length)}));
        }

        public int tableLength() {
            return this.table().length;
        }

        public void setSize(int sz) {
            this.tableSize_$eq(sz);
        }

        public int insertEntry(int insertAt, int comesBefore, Object newEntry) {
            int h = insertAt;
            if (h == -1) {
                h = this.index(newEntry.hashCode());
            }
            Object curEntry = this.table()[h];
            while (curEntry != null) {
                if (BoxesRunTime.equals((Object)curEntry, (Object)newEntry)) {
                    return 0;
                }
                if (++h >= comesBefore) {
                    return -1;
                }
                curEntry = this.table()[h];
            }
            this.table()[h] = newEntry;
            this.nnSizeMapAdd(h);
            return 1;
        }

        public final ParHashSetCombiner<T> scala$collection$parallel$mutable$ParHashSetCombiner$AddingFlatHashTable$$$outer() {
            return this.$outer;
        }
    }

    public class FillBlocks
    implements Task<Tuple2<Object, UnrolledBuffer<Object>>, FillBlocks> {
        private volatile Throwable throwable;
        private final UnrolledBuffer<Object>[] buckets;
        private final AddingFlatHashTable table;
        private final int offset;
        private final int howmany;
        private Tuple2 result;
        private final int blocksize;
        private final ParHashSetCombiner<T> $outer;

        public FillBlocks(ParHashSetCombiner $outer, UnrolledBuffer<Object>[] buckets, AddingFlatHashTable table, int offset, int howmany) {
            this.buckets = buckets;
            this.table = table;
            this.offset = offset;
            this.howmany = howmany;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Task.$init$(this);
            this.result = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), (Object)new UnrolledBuffer(ClassTag$.MODULE$.apply(Object.class)));
            this.blocksize = table.tableLength() >> ParHashSetCombiner$.MODULE$.discriminantbits();
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public void throwable_$eq(Throwable x$1) {
            this.throwable = x$1;
        }

        public int offset() {
            return this.offset;
        }

        public int howmany() {
            return this.howmany;
        }

        @Override
        public Tuple2<Object, UnrolledBuffer<Object>> result() {
            return this.result;
        }

        @Override
        public void result_$eq(Tuple2<Object, UnrolledBuffer<Object>> x$1) {
            this.result = x$1;
        }

        @Override
        public void leaf(Option<Tuple2<Object, UnrolledBuffer<Object>>> prev) {
            int totalinserts = 0;
            UnrolledBuffer leftover = new UnrolledBuffer(ClassTag$.MODULE$.apply(Object.class));
            for (int i = this.offset(); i < this.offset() + this.howmany(); ++i) {
                Tuple2<Object, UnrolledBuffer<Object>> tuple2 = this.fillBlock(i, this.buckets[i], (UnrolledBuffer<Object>)leftover);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int inserted = BoxesRunTime.unboxToInt((Object)tuple2._1());
                UnrolledBuffer intonextblock = (UnrolledBuffer)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)inserted), (Object)intonextblock);
                int inserted2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
                UnrolledBuffer intonextblock2 = (UnrolledBuffer)tuple22._2();
                totalinserts += inserted2;
                leftover = intonextblock2;
            }
            this.result_$eq((Tuple2<Object, UnrolledBuffer<Object>>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)totalinserts), (Object)leftover));
        }

        private int blockStart(int block) {
            return block * this.blocksize;
        }

        private int nextBlockStart(int block) {
            return (block + 1) * this.blocksize;
        }

        private Tuple2<Object, UnrolledBuffer<Object>> fillBlock(int block, UnrolledBuffer<Object> elems, UnrolledBuffer<Object> leftovers) {
            Tuple2 tuple2;
            int beforePos = this.nextBlockStart(block);
            Tuple2 tuple22 = tuple2 = elems != null ? this.insertAll(-1, beforePos, elems) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), UnrolledBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[0]), (Object)ClassTag$.MODULE$.apply(Object.class)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int elemsIn = BoxesRunTime.unboxToInt((Object)tuple2._1());
            UnrolledBuffer elemsLeft = (UnrolledBuffer)tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)elemsIn), (Object)elemsLeft);
            int elemsIn2 = BoxesRunTime.unboxToInt((Object)tuple23._1());
            UnrolledBuffer elemsLeft2 = (UnrolledBuffer)tuple23._2();
            Tuple2<Object, UnrolledBuffer<Object>> tuple24 = this.insertAll(this.blockStart(block), beforePos, leftovers);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            int leftoversIn = BoxesRunTime.unboxToInt((Object)tuple24._1());
            UnrolledBuffer leftoversLeft = (UnrolledBuffer)tuple24._2();
            Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)leftoversIn), (Object)leftoversLeft);
            int leftoversIn2 = BoxesRunTime.unboxToInt((Object)tuple25._1());
            UnrolledBuffer leftoversLeft2 = (UnrolledBuffer)tuple25._2();
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(elemsIn2 + leftoversIn2)), (Object)elemsLeft2.concat(leftoversLeft2));
        }

        private Tuple2<Object, UnrolledBuffer<Object>> insertAll(int atPos, int beforePos, UnrolledBuffer<Object> elems) {
            UnrolledBuffer leftovers = new UnrolledBuffer(ClassTag$.MODULE$.apply(Object.class));
            int inserted = 0;
            int i = 0;
            AddingFlatHashTable t = this.table;
            for (UnrolledBuffer.Unrolled unrolled = elems.headPtr(); unrolled != null; unrolled = unrolled.next()) {
                Object[] chunkarr = (Object[])unrolled.array();
                int chunksz = unrolled.size();
                while (i < chunksz) {
                    Growable growable;
                    Object entry = chunkarr[i];
                    int res = t.insertEntry(atPos, beforePos, entry);
                    if (res >= 0) {
                        inserted += res;
                        growable = BoxedUnit.UNIT;
                    } else {
                        growable = leftovers.$plus$eq(entry);
                    }
                    ++i;
                }
                i = 0;
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)inserted), (Object)leftovers);
        }

        @Override
        public Seq<Task<Tuple2<Object, UnrolledBuffer<Object>>, FillBlocks>> split() {
            int fp = this.howmany() / 2;
            return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FillBlocks[]{new FillBlocks(this.$outer, this.buckets, this.table, this.offset(), fp), new FillBlocks(this.$outer, this.buckets, this.table, this.offset() + fp, this.howmany() - fp)}));
        }

        public void merge(FillBlocks that) {
            int beforePos;
            int atPos = this.blockStart(that.offset());
            Tuple2<Object, UnrolledBuffer<Object>> tuple2 = this.insertAll(atPos, beforePos = this.blockStart(that.offset() + that.howmany()), (UnrolledBuffer<Object>)((UnrolledBuffer)this.result()._2()));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int inserted = BoxesRunTime.unboxToInt((Object)tuple2._1());
            UnrolledBuffer remainingLeftovers = (UnrolledBuffer)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)inserted), (Object)remainingLeftovers);
            int inserted2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            UnrolledBuffer remainingLeftovers2 = (UnrolledBuffer)tuple22._2();
            this.result_$eq((Tuple2<Object, UnrolledBuffer<Object>>)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.result()._1()) + BoxesRunTime.unboxToInt((Object)that.result()._1()) + inserted2)), (Object)remainingLeftovers2.concat((UnrolledBuffer)that.result()._2())));
        }

        @Override
        public boolean shouldSplitFurther() {
            return this.howmany() > package$.MODULE$.thresholdFromSize(ParHashMapCombiner$.MODULE$.numblocks(), this.$outer.combinerTaskSupport().parallelismLevel());
        }

        public final ParHashSetCombiner<T> scala$collection$parallel$mutable$ParHashSetCombiner$FillBlocks$$$outer() {
            return this.$outer;
        }
    }
}

