#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 8 Part 2.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for CW8 part 2
marks=$(( 0 ))

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc "$1" 2>> $out 1>> $out) 
}

# functional tests


function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -nc -i "$1" "$2" -e "") #2> /dev/null 1> /dev/null)
}

function scala_assert_slow {
  (ulimit -t 120; JAVA_OPTS="-Xmx1g" scala -nc -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}



# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# knights2: purity test
#
echo -e "knight2.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out


if (scala_vars knight2.scala)
then
  echo -e "  --> test failed" | tee -a $out
  tsts0=$(( 0 ))
else
  echo -e "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo -e "knight2.scala runs?" | tee -a $out

  if (scala_compile knight2.scala)
  then
    echo -e "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN KNIGHT2.SCALA\n" >> $out  
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi

# ordered move test

if [ $tsts1 -eq 0 ]
then
  echo -e " ordered_moves(8, List((3,4), (3,2)), (1,3)) == List((0,1), (0,5), (2,1), (2,5))" | tee -a $out
  echo -e " ordered_moves(8, List((4,0)), (0,0)) == List((2,1), (1,2))" | tee -a $out
  echo -e " ordered_moves(8, List((0,4)), (0,0)) == List((1,2), (2,1))" | tee -a $out
  
  if (scala_assert "knight2.scala" "knight_test6.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi


# first-closed-tour test

if [ $tsts1 -eq 0 ]
then
  echo -e " first_closed_tour_heuristic(6, List((3,3))) found and correct?" | tee -a $out
  
  if (scala_assert "knight2.scala" "knight_test7.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo -e " first_tour_heuristic(8, List((0,0))) found and correct?" | tee -a $out
  echo -e " first_tour_heuristic(30, List((0,0))) found and correct?" | tee -a $out
  
  if (scala_assert "knight2.scala" "knight_test8.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out 
  fi
fi


# knights3: purity test
#
echo -e "knight3.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out


if (scala_vars knight3.scala)
then
  echo "  --> test failed" | tee -a $out
  tsts0=$(( 0 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "knight3.scala runs?" | tee -a $out

  if (scala_compile knight3.scala)
  then
    echo "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN KNIGHT3.SCALA\n" >> $out  
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


if [ $tsts1 -eq 0 ]
then
  echo -e " tour_on_mega_board(70, List((0,0))) found and correct?" | tee -a $out
  
  if (scala_assert "knight3.scala" "knight_test9.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out 
  fi
fi


## final marks
echo "Overall mark for CW 8, Part 2" | tee -a $out
echo "$marks" | tee -a $out
