#!/bin/bash
set -euo pipefail

out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission of CW 8" >> $out
echo -e "" >> $out
echo -e "!! Important: !!" >> $out
echo -e "Because of limitations with our testing infrastructure, we can only" >> $out
echo -e "let code run for 10 seconds and then have to kill it. This might" >> $out
echo -e "mean your code is correct, but still marked as Fail. Remember" >> $out
echo -e "you can test your code on your own machine and benchmark it" >> $out
echo -e "against the reference implementation." >> $out
echo -e "" >> $out

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert_slow {
  (ulimit -t 120; JAVA_OPTS="-Xmx1g" scala -i "$1" "-- $2" 2> /dev/null 1> /dev/null)
}

function scala_assert_thirty {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}

function scala_assert_quick {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# knights1: purity test

echo -e "knight1.scala does not contain vars, returns etc?" >> $out

if (scala_vars knight1.scala)
then
  echo -e "  --> FAIL (make triple-sure your program conforms to the required format)" >> $out  
  tsts0=$(( 0 ))
else
  echo -e "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test

if [ $tsts0 -eq 0 ]
then    
  echo -e "knight1.scala runs?" >> $out

  if (scala_compile knight1.scala)
  then
    echo -e "  --> success " >> $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN KNIGHT1.SCALA\n" >> $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))   
fi

### knight1 test

if [ $tsts1 -eq 0 ]
then
    echo -e "For testing needs to take 10 seconds or less to execute: " >> $out
    echo -e " is_legal(8, Nil, (3, 4)) == true " >> $out
    echo -e " is_legal(8, List((4, 1), (1, 0)), (4, 1)) == false " >> $out
    echo -e " is_legal(2, Nil, (0, 0)) == true" >> $out                          

    if (scala_assert_quick "knight1.scala" "knight_test1.scala")
    then
        echo -e "  --> success" >> $out
    else
        echo -e "  --> \n ONE TEST FAILED\n" >> $out
    fi
fi

### knight2 test

if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out
  echo -e " legal_moves(8, Nil, (2,2)) == List((3,4), (4,3), (4,1), (3,0), (1,0), (0,1), (0,3), (1,4))" >> $out
  echo -e " legal_moves(8, Nil, (7,7)) == List((6,5), (5,6))" >> $out
  echo -e " legal_moves(8, List((4,1), (1,0)), (2,2)) == List((3,4), (4,3), (3,0), (0,1), (0,3), (1,4))" >> $out
  echo -e " legal_moves(8, List((6,6)), (7,7)) == List((6,5), (5,6))" >> $out
  echo -e " legal_moves(1, Nil, (0,0)) == Nil" >> $out
  echo -e " legal_moves(2, Nil, (0,0)) == Nil" >> $out
  echo -e " legal_moves(3, Nil, (0,0)) == List((1,2), (2,1))" >> $out
  
  if (scala_assert_quick "knight1.scala" "knight_test2.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


### knight3 test

if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out
  echo -e " count_tours from every position on the board" >> $out
  echo -e " dim = 1: 1" >> $out
  echo -e "       2: 0,0,0,0" >>  $out
  echo -e "       3: 0,0,0,0,0,0,0,0,0" >>  $out
  echo -e "       4: 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0" >> $out
  #echo -e "       5: 304,0,56,0,304,0,56,0,56,0,56,0,64,0,56,0,56,0,56,0,304,0,56,0,304" >> $out
  echo -e " enum_tours(5, List((0,0)) ) == 304 and all correct?" >> $out
  echo -e " enum_tours(5, List((0,1)) ) == 0" >> $out
  echo -e " enum_tours(5, List((0,2)) ) == 56 and all correct?" >> $out
  
  if (scala_assert_quick "knight1.scala" "knight_test3.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi

### knight4 test

if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out
  echo -e " Let f = (x:(Int, Int)) => if (x._1 > 3) Some(List(x)) else None " >> $out
  echo -e "   first(List((1,0),(2,0),(3,0),(4,0)), f) == Some(List((4,0)))" >> $out
  echo -e "   first(List((1,0),(2,0),(3,0)), f) == None" >> $out

  if (scala_assert_quick "knight1.scala" "knight_test4.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


### knight5 test

if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out
  echo -e " is first_tour(6, List((0, 0))) ok? " >> $out
  echo -e " is first_tour(4, List((0, 0))) == None " >> $out

  if (scala_assert_quick "knight1.scala" "knight_test5.scala") 
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi


echo -e "" >> $out
echo -e "" >> $out


# knights2: purity test
#
echo -e "knight2.scala does not contain vars, returns, Arrays, ListBuffers etc?" >> $out

if (scala_vars knight2.scala)
then
  echo -e "  --> Fail (make triple-sure your program conforms to the required format)" >> $out    
  tsts0=$(( 0 ))
else
  echo -e "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo -e "knight2.scala runs?" >> $out

  if (scala_compile knight2.scala)
  then
    echo -e "  --> success" >> $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN KNIGHT2.SCALA\n" >> $out  
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


# ordered move test

if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out  
  echo -e " ordered_moves(8, List((3,4), (3,2)), (1,3)) == List((0,1), (0,5), (2,1), (2,5))" >> $out
  echo -e " ordered_moves(8, List((4,0)), (0,0)) == List((2,1), (1,2))" >> $out
  echo -e " ordered_moves(8, List((0,4)), (0,0)) == List((1,2), (2,1))" >> $out
  
  if (scala_assert_quick "knight2.scala" "knight_test6.scala")
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi


# first-closed-tour test

if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out  
  echo -e " first_closed_tour_heuristic(6, List((3,3))) found and correct?" >> $out
  
  if (scala_assert_quick "knight2.scala" "knight_test7.scala")
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out  
  fi
fi



if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out   
  echo -e " first_tour_heuristic(8, List((0,0))) found and correct?" >> $out
  echo -e " first_tour_heuristic(30, List((0,0))) found and correct?" >> $out
  
  if (scala_assert_quick "knight2.scala" "knight_test8.scala")
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out 
  fi
fi


echo -e "" >> $out
echo -e "" >> $out

# knights3: purity test
#
echo -e "knight3.scala does not contain vars, returns, Arrays, ListBuffers etc?" >> $out


if (scala_vars knight3.scala)
then
  echo "  --> Fail (make triple-sure your program conforms to the required format)xsxs" >> $out
  tsts0=$(( 0 ))
else
  echo "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "knight3.scala runs?" >> $out

  if (scala_compile knight3.scala)
  then
    echo "  --> success" >> $out
    tsts1=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN KNIGHT3.SCALA\n" >> $out  
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi


if [ $tsts1 -eq 0 ]
then
  echo -e "For testing needs to take 10 seconds or less to execute: " >> $out  
  echo -e " tour_on_mega_board(70, List((0,0))) found and correct?" >> $out
  
  if (scala_assert_quick "knight3.scala" "knight_test9.scala")
  then
      echo -e "  --> success" >> $out
  else
      echo -e "  --> \n ONE TEST FAILED\n" >> $out 
  fi
fi

