#!/bin/bash

# to make the script fail safely
set -euo pipefail

out=${1:-output}

echo "" > $out

echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for assignment 7 Part 1.  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

echo "Below is the feedback for your submission of CW 7, Part 1." >> $out
echo "" >> $out


# marks for CW7 part 1
marks=$(( 0 ))


# compilation tests (used to be 30 secs)

function scala_compile {
  (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala "$1" 2> /dev/null 1> /dev/null) 
}

# functional tests

function scala_assert {
  (ulimit -t 360; JAVA_OPTS="-Xmx1g" scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
}


# knights1: purity test

echo "knight1.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars knight1.scala)
then
  echo "  --> fail" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test

if [ $tsts0 -eq 0 ]
then    
  echo "knight1.scala runs?" | tee -a $out

  if (scala_compile knight1.scala)
  then
    echo "  --> success " | tee -a $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala did not run knight1.scala" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))   
fi

### knight1a test

if [ $tsts1 -eq 0 ]
then
    echo " is_legal(8, Nil)(3, 4) == true " | tee -a $out
    echo " is_legal(8, List((4, 1), (1, 0)))(4, 1) == false " | tee -a $out
    echo " is_legal(2, Nil)(0, 0) == true" | tee -a $out                          

    if (scala_assert "knight1.scala" "knight1a_test.scala")
    then
        echo "  --> success" | tee -a $out
	marks=$(( marks + 1 ))
    else
        echo "  --> test failed" | tee -a $out
    fi
fi

### knight1b test

if [ $tsts1 -eq 0 ]
then
  echo " legal_moves(8, Nil, (2,2)) == List((3,4), (4,3), (4,1), (3,0), (1,0), (0,1), (0,3), (1,4))" | tee -a $out
  echo " legal_moves(8, Nil, (7,7)) == List((6,5), (5,6))" | tee -a $out
  echo " legal_moves(8, List((4,1), (1,0)), (2,2)) == List((3,4), (4,3), (3,0), (0,1), (0,3), (1,4))" | tee -a $out
  echo " legal_moves(8, List((6,6)), (7,7)) == List((6,5), (5,6))" | tee -a $out
  echo " legal_moves(1, Nil, (0,0)) == Nil" | tee -a $out
  echo " legal_moves(2, Nil, (0,0)) == Nil" | tee -a $out
  echo " legal_moves(3, Nil, (0,0)) == List((1,2), (2,1))" | tee -a $out
  
  if (scala_assert "knight1.scala" "knight1b_test.scala")
  then
     echo "  --> success" | tee -a $out
     marks=$(( marks + 1 ))
  else
    echo "  --> test failed" | tee -a $out
  fi
fi


### knight1c test

if [ $tsts1 -eq 0 ]
then
  echo " all_tours from every position on the board" | tee -a $out
  echo " dim = 1: 1" | tee -a $out
  echo "       2: 0,0,0,0" >>  $out
  echo "       3: 0,0,0,0,0,0,0,0,0" >>  $out
  echo "       4: 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0" | tee -a $out
  echo "       5: 304,0,56,0,304,0,56,0,56,0,56,0,64,0,56,0,56,0,56,0,304,0,56,0,304" | tee -a $out
  echo " enum_tours(5, List((0,2)) ) => 56 tours? and all correct?" | tee -a $out
  
  if (scala_assert "knight1.scala" "knight1c_test.scala") 
  then
     echo "  --> success" | tee -a $out
     marks=$(( marks + 2 ))
  else
    echo "  --> test failed" | tee -a $out
  fi
fi


# knights2: var test

echo "knight2.scala does not contain vars, returns, Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars knight2.scala)
then
  echo "  --> fail" | tee -a $out
  tsts0=$(( 1 ))
else
  echo "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then    
  echo "knight2.scala runs?" | tee -a $out

  if (scala_compile knight2.scala)
  then
    echo "  --> success" | tee -a $out
    tsts1=$(( 0 ))
  else
    echo "  --> scala did not run knight2.scala" | tee -a $out
    tsts1=$(( 1 )) 
  fi
else
  tsts1=$(( 1 ))     
fi

### knight2a test

if [ $tsts1 -eq 0 ]
then
  echo " val f = (x:(Int, Int)) => if (x._1 > 3) Some(List(x)) else None " | tee -a $out
  echo "   first(List((1,0),(2,0),(3,0),(4,0)), f) == Some(List((4,0)))" | tee -a $out
  echo "   first(List((1,0),(2,0),(3,0)), f) == None" | tee -a $out

  if (scala_assert "knight2.scala" "knight2a_test.scala") 
  then
    echo "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo "  --> test failed" | tee -a $out
  fi
fi


### knight2b test

if [ $tsts1 -eq 0 ]
then
  echo " is first_tour(8, List((0, 0))) ok? " | tee -a $out
  echo " is first_tour(4, List((0, 0))) == None " | tee -a $out

  if (scala_assert "knight2.scala" "knight2b_test.scala") 
  then
     echo "  --> success" | tee -a $out
     marks=$(( marks + 2 ))
  else
    echo "  --> test failed" | tee -a $out
  fi
fi


## final marks
echo "Overall mark for Part 1" | tee -a $out
echo "$marks" | tee -a $out


