// Part 2 about finding a single tour for a board
//================================================

type Pos = (Int, Int)    // a position on a chessboard 
type Path = List[Pos]    // a path...a list of positions


// for measuring time
def time_needed[T](n: Int, code: => T) : T = {
  val start = System.nanoTime()
  for (i <- 0 until n) code
  val result = code
  val end = System.nanoTime()
  println("Time needed: " + (end - start) / 1.0e9 + " secs.")
  result
}


def print_board(dim: Int, path: Path): Unit = {
  println
  for (i <- 0 until dim) {
    for (j <- 0 until dim) {
      print(f"${path.reverse.indexOf((i, j))}%3.0f ")
    }
    println
  } 
}

def add_pair(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair(x))

def legal_moves(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves(x).filter(is_legal(dim, path))


def first(xs: List[Pos], f: Pos => Option[Path]): Option[Path] = xs match {
  case Nil => None
  case x::xs => {
    val result = f(x)
    if (result.isDefined) result else first(xs, f)
  }
}

first(List((1, 0),(2, 0),(3, 0),(4, 0)), (x => if (x._1 > 3) Some(List(x)) else None))
first(List((1, 0),(2, 0),(3, 0)), (x => if (x._1 > 3) Some(List(x)) else None))



def first_tour(dim: Int, path: Path): Option[Path] = {
  if (path.length == dim * dim) Some(path)
  else
    first(legal_moves(dim, path, path.head), (x: Pos) => first_tour(dim, x::path))
}

/*
for (dim <- 1 to 8) {
  val t = first_tour(dim, List((0, 0)))
  println(s"${dim} x ${dim} " + (if (t == None) "" else { print_board(dim, t.get) ; "" }))
}
*/

// 15 secs for 8 x 8
val ts1 = time_needed(0,first_tour(8, List((0, 0))).get)

// no result for 4 x 4
val ts2 = time_needed(0, first_tour(4, List((0, 0))))

// 0.3 secs for 6 x 6
val ts3 = time_needed(0, first_tour(6, List((0, 0))))

// 15 secs for 8 x 8
time_needed(0, print_board(8, first_tour(8, List((0, 0))).get))


