
// first test 


def urban_groupById(ratings: List[(String, String)]) = 
  ratings.groupBy(_._1).mapValues(_.map(_._2)) 

def urban_get_csv_file(name: String) : List[String] = {
  import io.Source
  import scala.util._
  val csv = Source.fromFile(name)
  csv.mkString.split("\n").toList.drop(1)
}

def urban_process_ratings(lines: List[String]) : List[(String, String)] = {
  for (cols <- lines.map(_.split(",").toList); 
       if (cols(2).toFloat >= 4)) yield (cols(0), cols(1))  
}

def urban_process_movies(lines: List[String]) : List[(String, String)] = {
  for (cols <- lines.map(_.split(",").toList)) yield (cols(0), cols(1))  
}


val urban_good_ratings = process_ratings(urban_get_csv_file("ratings.csv"))
val urban_movie_names = process_movies(urban_get_csv_file("movies.csv")).toMap

val urban_ratings_map = urban_groupById(urban_good_ratings)

assert((for (n <- List("1", "2", "3", "4", "5")) yield {
  recommendations(urban_ratings_map, urban_movie_names, n).length
}) == List(2, 2, 2, 0, 2))

