// Part 2 about finding a single tour for a board
//================================================


type Pos = (Int, Int)
type Path = List[Pos]

def print_board(dim: Int, path: Path): Unit = {
  println
  for (i <- 0 until dim) {
    for (j <- 0 until dim) {
      print(f"${path.reverse.indexOf((i, j))}%3.0f ")
    }
    println
  } 
}

def add_pair(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair(x))

def legal_moves(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves(x).filter(is_legal(dim, path))

def ordered_moves(dim: Int, path: Path, x: Pos): List[Pos] = 
  legal_moves(dim, path, x).sortBy((x) => legal_moves(dim, path, x).length)


def first(xs: List[Pos], f: Pos => Option[Path]): Option[Path] = xs match {
  case Nil => None
  case x::xs => {
    val result = f(x)
    if (result.isDefined) result else first(xs, f)
  }
}


def first_closed_tour_heuristics(dim: Int, path: Path): Option[Path] = {
  if (path.length == dim * dim && moves(path.head).contains(path.last)) Some(path)
  else
    first(ordered_moves(dim, path, path.head), (x: Pos) => first_closed_tour_heuristics(dim, x::path))
}

for (dim <- 1 to 7) {
  val t = first_closed_tour_heuristics(dim, List((dim / 2, dim / 2)))
  println(s"${dim} x ${dim} closed: " + (if (t == None) "" else { print_board(dim, t.get) ; "" }))
}


def first_tour_heuristics(dim: Int, path: Path): Option[Path] = {
  if (path.length == dim * dim) Some(path)
  else
    first(ordered_moves(dim, path, path.head), (x: Pos) => first_tour_heuristics(dim, x::path))
}

for (dim <- 1 to 50) {
  val t = first_tour_heuristics(dim, List((dim / 2, dim / 2)))
  println(s"${dim} x ${dim}: " + (if (t == None) "" else { print_board(dim, t.get) ; "" }))
}
