

val trades = List(28.0, 18.0, 20.0, 26.0, 24.0)

def trade_times(xs: List[Double]): (Int, Int) = {
  val low = xs.min
  val low_index = xs.indexOf(low)
  val rest = xs.drop(low_index)
  val high = rest.max
  val high_index = rest.indexOf(high)
  (low_index, low_index + high_index)
}


trade_times(trades)

assert(trade_times(List(10.0, 8.0, 7.0, 6.0)) == (3, 3), "the first test fails")



import io.Source
import scala.util._

def get_page(url: String): List[String] = {
  Try(Source.fromURL(url)("ISO-8859-1").getLines.toList).
    getOrElse { println(s"  Problem with: $url"); List() }
}

def process_page(url: String): List[(String, Double)] = {
  get_page(url).drop(1).map(_.split(",").toList).map((xs) => (xs(0), xs(6).toDouble))
}

def query_comp(name: String): (Int, Int) = {
  val list = process_page("""http://ichart.yahoo.com/table.csv?s=""" + name)
  trade_times(list.reverse.map(_._2))
}


val indices = List("GOOG", "AAPL", "MSFT", "IBM", "FB", "YHOO", "AMZN", "BIDU")

indices.map(query_comp(_))

val appl_page = get_page("""http://ichart.yahoo.com/table.csv?s=GOOG""")
val goog_page = get_page("""http://ichart.yahoo.com/table.csv?s=GOOG""")
goog_page.length

val pairs = goog_page.drop(1).map(_.split(",").toList).map((xs:List[String]) => (xs(0), xs(6).toDouble))

pairs.map(_._2)

trade_times(pairs.reverse.map(_._2))

pairs(3067)
pairs(11)


/*
scala trade.scala 2> /dev/null || echo "command1 borked it"

command1
if [ $? -ne 0 ]; then
    echo "command1 borked it"
fi
*/


