// Lecture 1
//===========

// Value assignments
// (variable names should be lower case)
//======================================

val x = 42
val y = 3 + 4


// Collections
//=============
List(1,2,3,1)
Set(1,2,3,1)

1 to 10
(1 to 10).toList

(1 until 10).toList

// an element in a list
List(1, 2, 3, 1)(0)
List(1, 2, 3, 1)(3)

1::2::3::Nil
List(1, 2, 3) ::: List(4, 5, 6)

// Printing/Strings
//==================

println("test")


val tst = "This is a " ++ "test\n" 
println(tst)

val lst = List(1,2,3,1)

println(lst.toString)
println(lst.mkString("\n"))

// some methods take more than one argument
println(lst.mkString("[", ",", "]"))


// Conversion methods
//====================

List(1,2,3,1).toString
List(1,2,3,1).toSet
"hello".toList
1.toDouble


// useful list methods

List(1,2,3,4).length
List(1,2,3,4).reverse
List(1,2,3,4).max
List(1,2,3,4).min
List(1,2,3,4).sum
List(1,2,3,4).take(2).sum
List(1,2,3,4).drop(2).sum
List(1,2,3,4,3).indexOf(3)

"1,2,3,4,5".split(",").toList


// Types
//=======

/* Scala is a strongly typed language
 
 * Base types

    Int, Long, BigInt, Float, Double
    String, Char
    Boolean

 * Compound types 

    List[Int],
    Set[Double]
    Pairs: (Int, String)        
    List[(BigInt, String)]
*/

// Smart Strings
//===============

println(">\n<")
println(""">\n<""")

/* in Java
val lyrics = "Baa, Baa, Black Sheep \n" +
             "Have you any wool? \n" +
             "Yes, sir, yes sir \n" +
             "Three bags full"
*/ 

val lyrics = """Baa, Baa, Black Sheep  
                |Have you any wool?
                |Yes, sir, yes sir
                |Three bags full""".stripMargin

println(lyrics)


// Pairs/Tuples
//==============

val p = (1, "one")
p._1
p._2

val t = (4,1,2,3)
t._4

// Hello World
//=============

// an example of a stand-alone scala file;
// in the coursework students must submit 
// plain scala "work-sheets"

object Hello extends App { 
  println("hello world")
}

// can be called with
//
// $> scalac hello-world.scala
// $> scala Hello
//
// $> java -cp /usr/local/src/scala/lib/scala-library.jar:. Hello


// Function Definitions
//======================

def square(x: Int): Int = x * x

square(6)


// If control structure
//======================

def fact(n: Int): Int = 
  if (n == 0) 1 else n * fact(n - 1)

/* boolean operators
 
   ==     equals
   !      not
   && ||  and, or
*/


def fact2(n: BigInt): BigInt = 
  if (n == 0) 1 else n * fact2(n - 1)

fact2(150)


def fib(n: Int): Int =
  if (n == 0) 1 else
    if (n == 1) 1 else fib(n - 1) + fib(n - 2)


//gcd - Euclid's algorithm

def gcd(a: Int, b: Int): Int =
  if (b == 0) a else gcd(b, a % b)

gcd(48, 18)


// String Interpolations
//=======================

val n = 3
println("The square of " + n + " is " + square(n) + ".")

println(s"The square of ${n} is ${square(n)}.")



def gcd_db(a: Int, b: Int): Int = {
  println(s"Function called with ${a} and ${b}.")
  if (b == 0) a else gcd_db(b, a % b)
}

gcd_db(48, 18)


// Assert/Testing
//================

assert(gcd(48, 18) == 6)

assert(gcd(48, 18) == 5, "The gcd test failed")


// For-Comprehensions (not For-Loops)
//====================================

for (n <- (1 to 10).toList) yield square(n)

for (n <- (1 to 10).toList; 
     m <- (1 to 10).toList) yield m * n


val mult_table = 
  for (n <- (1 to 10).toList; 
       m <- (1 to 10).toList) yield m * n

mult_table.sliding(10,10).mkString("\n")


// with if-predicates

for (n <- (1 to 3).toList; 
     m <- (1 to 3).toList;
     if (n + m) % 2 == 0) yield (n, m)



// with patterns

for ((m, n) <- List((1, 4), (2, 3), (3, 2), (4, 1))) yield m + n 

for (p <- List((1, 4), (2, 3), (3, 2), (4, 1))) yield p._1 + p._2 



// with only a side-effect (no list is produced)
// has no "yield"

for (n <- (1 to 10)) println(n)


// concurrency (ONLY WORKS IN 2.11.8)
for (n <- (1 to 10)) println(n)
for (n <- (1 to 10).par) println(n)



// for testing time
def time_needed[T](i: Int, code: => T) = {
  val start = System.nanoTime()
  for (j <- 1 to i) code
  val end = System.nanoTime()
  ((end - start) / i / 1.0e9) + " secs"
}

val list = (1 to 1000000).toList
time_needed(10, for (n <- list) yield n + 42)
time_needed(10, for (n <- list.par) yield n + 42)



// Webpages
//==========

import io.Source

val url = """http://www.inf.kcl.ac.uk/staff/urbanc/""" 
Source.fromURL(url)("ISO-8859-1").mkString



def price_lookup(symbol: String): String = {
  val url = "http://finance.yahoo.com/d/quotes.csv?s=" + symbol + "&f=snl1"
  Source.fromURL(url).mkString.drop(1).dropRight(2)
}

price_lookup("GOOG")
price_lookup("AAPL")


val companies = 
  List("GOOG", "AAPL", "MSFT", "IBM", "FB", "YHOO", "AMZN", "BIDU")

for (s <- companies.par) println(price_lookup(s))


// A Web Crawler
//===============

import io.Source
import scala.util.matching.Regex
import scala.util._

// gets the first 10K of a web-page
def get_page(url: String) : String = {
  Try(Source.fromURL(url)("ISO-8859-1").take(10000).mkString).
    getOrElse { println(s"  Problem with: $url"); ""}
}

// regex for URLs
val http_pattern = """"https?://[^"]*"""".r

// drops the first and last character from a string
def unquote(s: String) = s.drop(1).dropRight(1)

def get_all_URLs(page: String): Set[String] = 
  http_pattern.findAllIn(page).map(unquote).toSet

// naive version of crawl - searches until a given depth,
// visits pages potentially more than once
def crawl(url: String, n: Int): Unit = {
  if (n == 0) ()
  else {
    println(s"Visiting: $n $url")
    for (u <- get_all_URLs(get_page(url))) crawl(u, n - 1)
  }
}

// some starting URLs for the crawler
val startURL = """http://www.inf.kcl.ac.uk/staff/urbanc"""
//val startURL = """http://www.inf.kcl.ac.uk/staff/mcburney"""

crawl(startURL, 2)




// Adding your own methods to Strings
//====================================

// imagine you want to implement an additional
// method to strings, like
//
//     "HAL".increment
//
// you can avoid ugly fudges, like a MyString
// class by using implicit conversions


implicit class MyString(s: String) {
  def increment = for (c <- s) yield (c + 1).toChar 
}

"HAL".increment


// Further Information
//=====================

// Scala download
//
//  http://www.scala-lang.org

// Eclipse for Scala
//
//  http://scala-ide.org/download/sdk.html


// library docs
//
//  http://www.scala-lang.org/api/current/

// tutorials
//
//  http://docs.scala-lang.org/tutorials/
